/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.hb0730.commons.lang.Validate;
import java.util.List;
import java.util.Map;

public class FastJsonUtils {
    public static <T> T jsonToObject(String json, Class<T> type) {
        return FastJsonUtils.jsonToObject(json, type, ParserConfig.getGlobalInstance());
    }

    public static <T> T jsonToObject(String json, Class<T> type, ParserConfig config) {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target class type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)config, (String)"parser config must be not null", (Object[])new Object[0]);
        return (T)JSON.parseObject((String)json, type, (ParserConfig)config, (Feature[])new Feature[0]);
    }

    public static <T> List<T> jsonToList(String json, Class<T> type) {
        return FastJsonUtils.jsonToList(json, type, ParserConfig.getGlobalInstance());
    }

    public static <T> List<T> jsonToList(String json, Class<T> type, ParserConfig config) {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target class type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)config, (String)"parser config must be not null", (Object[])new Object[0]);
        return JSONArray.parseArray((String)json, type, (ParserConfig)config);
    }

    public static String objectToJson(Object source) {
        return FastJsonUtils.objectToJson(source, SerializeConfig.getGlobalInstance());
    }

    public static String objectToJson(Object source, SerializeConfig config) {
        Validate.notNull((Object)source, (String)"source object must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)config, (String)"serialize config must be not null", (Object[])new Object[0]);
        return JSON.toJSONString((Object)source, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) {
        return FastJsonUtils.mapToObject(sourceMap, type, SerializeConfig.getGlobalInstance());
    }

    public static <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, SerializeConfig config) {
        Validate.notNull(sourceMap, (String)"source map must be not null", (Object[])new Object[0]);
        String json = FastJsonUtils.objectToJson(sourceMap, config);
        return FastJsonUtils.jsonToObject(json, type);
    }

    public static Map<?, ?> objectToMap(Object source) {
        return FastJsonUtils.objectToMap(source, SerializeConfig.getGlobalInstance());
    }

    public static Map<?, ?> objectToMap(Object source, SerializeConfig config) {
        String json = FastJsonUtils.objectToJson(source, config);
        return FastJsonUtils.jsonToObject(json, Map.class);
    }
}

