/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.hb0730.commons.json.AbstractJson;
import com.hb0730.commons.json.exceptions.JsonException;
import com.hb0730.commons.lang.Validate;
import java.util.List;
import java.util.Map;

public class FastJsonImpl
extends AbstractJson {
    public static final ParserConfig PARSER_CONFIG = ParserConfig.getGlobalInstance();
    public static final SerializeConfig SERIALIZE_CONFIG = SerializeConfig.getGlobalInstance();
    private ParserConfig parserConfig;
    private SerializeConfig serializeConfig;

    @Override
    @Deprecated
    public void setMapper(Object mapper) throws JsonException {
    }

    @Override
    @Deprecated
    public Object getMapper() {
        return null;
    }

    public ParserConfig getParserConfig() {
        if (null == this.parserConfig) {
            return PARSER_CONFIG;
        }
        return this.parserConfig;
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public SerializeConfig getSerializeConfig() {
        if (null == this.serializeConfig) {
            return SERIALIZE_CONFIG;
        }
        return this.serializeConfig;
    }

    public void setSerializeConfig(SerializeConfig serializeConfig) {
        this.serializeConfig = serializeConfig;
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type) throws JsonException {
        return this.jsonToObject(json, type, this.getParserConfig());
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type, Object parserConfig) throws JsonException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target class type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)parserConfig, (String)"parserConfig must be not null", (Object[])new Object[0]);
        if (parserConfig instanceof ParserConfig) {
            try {
                return (T)JSON.parseObject((String)json, type, (ParserConfig)((ParserConfig)parserConfig), (Feature[])new Feature[0]);
            }
            catch (JSONException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type) throws JsonException {
        return this.jsonToList(json, type, this.getParserConfig());
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type, Object parserConfig) throws JsonException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target class type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)parserConfig, (String)"parserConfig must be not null", (Object[])new Object[0]);
        if (parserConfig instanceof ParserConfig) {
            try {
                return JSONArray.parseArray((String)json, type, (ParserConfig)((ParserConfig)parserConfig));
            }
            catch (JSONException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public String objectToJson(Object source) throws JsonException {
        return this.objectToJson(source, this.getSerializeConfig());
    }

    @Override
    public String objectToJson(Object source, Object serializeConfig) throws JsonException {
        Validate.notNull((Object)source, (String)"source object must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)serializeConfig, (String)"serializeConfig config must be not null", (Object[])new Object[0]);
        if (serializeConfig instanceof SerializeConfig) {
            try {
                return JSON.toJSONString((Object)source, (SerializeConfig)((SerializeConfig)serializeConfig), (SerializerFeature[])new SerializerFeature[0]);
            }
            catch (JSONException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) throws JsonException {
        return this.mapToObject(sourceMap, type, this.getSerializeConfig());
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, Object serializeConfig) throws JsonException {
        Validate.notNull(sourceMap, (String)"source map must be not null", (Object[])new Object[0]);
        String json = this.objectToJson(sourceMap, serializeConfig);
        return this.jsonToObject(json, type);
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source) throws JsonException {
        return this.objectToMap(source, this.getSerializeConfig());
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source, Object serializeConfig) throws JsonException {
        String json = this.objectToJson(source, serializeConfig);
        try {
            return (Map)JSON.parseObject((String)json, Map.class, (ParserConfig)this.getParserConfig(), (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            throw new JsonException(e);
        }
    }
}

