/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.hb0730.commons.json.AbstractJson;
import com.hb0730.commons.json.exceptions.JsonException;
import com.hb0730.commons.lang.Validate;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JacksonImpl
extends AbstractJson {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void setMapper(Object mapper) throws JsonException {
        if (!(mapper instanceof ObjectMapper)) {
            throw new JsonException("Illegal type");
        }
        this.mapper = mapper;
    }

    @Override
    public Object getMapper() {
        if (null == this.mapper) {
            return MAPPER;
        }
        return this.mapper;
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type) throws JsonException {
        return this.jsonToObject(json, type, this.getMapper());
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type, Object mapper) throws JsonException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)mapper, (String)"ObjectMapper must be not null", (Object[])new Object[0]);
        if (mapper instanceof ObjectMapper) {
            try {
                return (T)((ObjectMapper)mapper).readValue(json, type);
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type) throws JsonException {
        return this.jsonToList(json, type, this.getMapper());
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type, Object mapper) throws JsonException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)mapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        if (mapper instanceof ObjectMapper) {
            try {
                CollectionType collectionType = ((ObjectMapper)mapper).getTypeFactory().constructCollectionType(List.class, type);
                return (List)((ObjectMapper)mapper).readValue(json, (JavaType)collectionType);
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    public <T> List<T> jsonToList2(String json, Class<T> type) throws IOException {
        return this.jsonToList2(json, type, (ObjectMapper)this.getMapper());
    }

    public <T> List<T> jsonToList2(String json, Class<T> type, ObjectMapper objectMapper) throws IOException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)objectMapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        return (List)objectMapper.readValue(json, new TypeReference<List<T>>(){});
    }

    @Override
    public String objectToJson(Object source) throws JsonException {
        return this.objectToJson(source, this.getMapper());
    }

    @Override
    public String objectToJson(Object source, Object mapper) throws JsonException {
        Validate.notNull((Object)source, (String)"source object must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)mapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        if (mapper instanceof ObjectMapper) {
            try {
                return ((ObjectMapper)mapper).writeValueAsString(source);
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) throws JsonException {
        return this.mapToObject(sourceMap, type, this.getMapper());
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, Object mapper) throws JsonException {
        Validate.notNull(sourceMap, (String)"source map must be not null", (Object[])new Object[0]);
        String json = this.objectToJson(sourceMap, mapper);
        return this.jsonToObject(json, type, mapper);
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source) throws JsonException {
        return this.objectToMap(source, this.getMapper());
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source, Object mapper) throws JsonException {
        String json = this.objectToJson(source, mapper);
        return this.jsonToObject(json, Map.class, mapper);
    }
}

