/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.date;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtils {
    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static Calendar calendar(Date date) {
        return CalendarUtils.calendar(date.getTime());
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }
}

