/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.io;

import com.hb0730.commons.lang.Charsets;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class IOUtils {
    public static final int EOF = -1;

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (null != data && null != output) {
            output.write(data);
        }
    }

    public static void write(char[] data, OutputStream output, String encoding) throws IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(char[] data, OutputStream output, Charset encoding) throws IOException {
        if (null != data && null != output) {
            output.write(new String(data).getBytes(Charsets.toCharset(encoding)));
        }
    }

    public static void write(CharSequence data, OutputStream output, String encoding) throws IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(CharSequence data, OutputStream output, Charset encoding) throws IOException {
        if (null != data && null != output) {
            IOUtils.write(data.toString(), output, encoding);
        }
    }

    public static void write(String data, OutputStream out, Charset charset) throws IOException {
        if (null != data && null != out) {
            out.write(data.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void closeQuietly(OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

