/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.net;

import com.hb0730.commons.lang.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class IpUtils {
    public static final int PORT_RANGE_MAX = 65535;
    private static final String ANYHOST = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    public static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile String LOCAL_ADDRESS = null;

    public static String getIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (IpUtils.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StringUtils.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getIp() {
        return IpUtils.getAddress();
    }

    public static String getIpPort(int port) {
        String ip = IpUtils.getIp();
        if (ip == null) {
            return null;
        }
        return ip.concat(":").concat(String.valueOf(port));
    }

    public static String getAddress() {
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        InetAddress address = IpUtils.getFirstValidAddress();
        LOCAL_ADDRESS = address == null ? null : address.getHostAddress();
        return LOCAL_ADDRESS;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress() || address.isLinkLocalAddress()) {
            return false;
        }
        String hostAddress = address.getHostAddress();
        return null != hostAddress && !ANYHOST.equals(hostAddress) && !LOCALHOST.equals(hostAddress) && IP_PATTERN.matcher(hostAddress).matches();
    }

    private static InetAddress getFirstValidAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null != interfaces) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface network = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress inetAddress = addresses.nextElement();
                        if (!IpUtils.isValidAddress(inetAddress)) continue;
                        return inetAddress;
                    }
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (IpUtils.isValidAddress(localHost)) {
                return localHost;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }
}

