/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.net;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UrlUtils {
    public static String urlEncode(String params) throws UnsupportedEncodingException {
        Validate.notNull(params, "params must be not null", new Object[0]);
        return UrlUtils.urlEncode(params, StandardCharsets.UTF_8.displayName());
    }

    public static String urlEncode(String params, String enc) throws UnsupportedEncodingException {
        Charset charset = StringUtils.isBlank(enc) ? StandardCharsets.UTF_8 : Charset.forName(enc);
        return UrlUtils.urlEncode(params, charset);
    }

    public static String urlEncode(String params, Charset enc) throws UnsupportedEncodingException {
        Validate.notNull(params, "params must be not null", new Object[0]);
        String encode = URLEncoder.encode(params, enc.displayName());
        return encode.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
    }

    public static String urlDecoder(String params) throws UnsupportedEncodingException {
        return UrlUtils.urlDecoder(params, StandardCharsets.UTF_8.displayName());
    }

    public static String urlDecoder(String params, String enc) throws UnsupportedEncodingException {
        Charset charset = StringUtils.isBlank(enc) ? StandardCharsets.UTF_8 : Charset.forName(enc);
        return UrlUtils.urlDecoder(params, charset);
    }

    public static String urlDecoder(String params, Charset enc) throws UnsupportedEncodingException {
        Validate.notNull(params, "params must be not null", new Object[0]);
        Validate.notNull(enc, "charset must be not null", new Object[0]);
        return URLDecoder.decode(params, enc.displayName());
    }
}

