/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;

public class BooleanUtils {
    public static final String[] TRUE_ARRAY = new String[]{"yes", "y", "1", "ok", "true", "on"};

    public static boolean toBoolean(String value) {
        if (StringUtils.isNotBlank(value)) {
            value = value.trim().toLowerCase();
            return ArrayUtils.contains(TRUE_ARRAY, value);
        }
        return false;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(Boolean value) {
        return BooleanUtils.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanUtils.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanUtils.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanUtils.toInt(value);
    }

    public static Byte toByteObj(Boolean value) {
        return BooleanUtils.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanUtils.toInt(value);
    }

    public static Long toLongObj(Boolean value) {
        return BooleanUtils.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanUtils.toInt(value);
    }

    public static Short toShortObj(Boolean value) {
        return BooleanUtils.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanUtils.toInt(value);
    }

    public static Float toFloatObj(Boolean value) {
        return Float.valueOf(BooleanUtils.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanUtils.toInt(value);
    }

    public static Double toDoubleObj(Boolean value) {
        return BooleanUtils.toDouble(value);
    }
}

