/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang;

import com.hb0730.commons.lang.CharUtils;
import com.hb0730.commons.lang.Validate;

public class StringUtils {
    public static boolean isBlank(CharSequence str) {
        int len;
        if (null == str || (len = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (CharUtils.isBlank(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtils.equals(s1, s2, false);
    }

    public static boolean equals(CharSequence s1, CharSequence s2, boolean ignoreCase) {
        if (null == s1) {
            return null == s2;
        }
        if (null == s2) {
            return false;
        }
        if (ignoreCase) {
            return s1.toString().equalsIgnoreCase(s2.toString());
        }
        return s1.toString().contentEquals(s2);
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trimStart(CharSequence value) {
        return StringUtils.trim(value, -1);
    }

    public static String trimEnd(CharSequence value) {
        return StringUtils.trim(value, 1);
    }

    public static String trimAll(CharSequence value) {
        return StringUtils.trim(value, 0);
    }

    public static String trim(CharSequence value, int mode) {
        int start;
        if (value == null) {
            return "";
        }
        int len = value.length();
        int end = len;
        if (mode <= 0) {
            for (start = 0; start < end && CharUtils.isBlank(value.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharUtils.isBlank(value.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < len) {
            return value.toString().substring(start, end);
        }
        return value.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || 0 == str.length();
    }

    public static boolean contains(String str, char v) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.indexOf(v) > -1;
    }

    public static boolean contains(String str, String searchStr) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.contains(searchStr);
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringUtils.endWith(str, suffix, false);
    }

    public static boolean endWith(CharSequence str, char c) {
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return false;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static String ensureSuffix(String string, String suffix) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(suffix)) {
            return string;
        }
        return StringUtils.removeEnd(string, suffix) + suffix;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String appendIfNotContain(String str, String appendStr, String otherwise) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(appendStr)) {
            return str;
        }
        if (str.contains(appendStr)) {
            return str.concat(otherwise);
        }
        return str.concat(appendStr);
    }

    public static String appendIfNotEndsWith(String str, String suffix, String appendStr) {
        if (StringUtils.endWithIgnoreCase(str, suffix)) {
            return str.concat(appendStr);
        }
        return str;
    }

    public static String join(CharSequence ... elements) {
        Validate.notEmpty(elements, "element not empty", new Object[0]);
        StringBuilder sb = new StringBuilder(elements.length);
        for (CharSequence element : elements) {
            sb.append(element);
        }
        return sb.toString();
    }
}

