/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang;

import com.hb0730.commons.lang.StringUtils;
import java.util.Collection;
import java.util.Map;

public class Validate {
    private static final String DEFAULT_IS_TRUE_EX_MESSAGE = "The validated expression is false";
    private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
    private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";
    private static final String DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE = "The validated collection is empty";
    private static final String DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE = "The validated map is empty";
    private static final String DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence is empty";
    private static final String DEFAULT_NOT_BLANK_EX_MESSAGE = "The validated character sequence is blank";

    public static void isTrue(boolean expression, String message, Object value) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, value));
        }
    }

    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(DEFAULT_IS_TRUE_EX_MESSAGE);
        }
    }

    public static void notNull(Object value) {
        Validate.notNull(value, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
    }

    public static void notNull(Object value, String message, Object ... values) {
        if (null == value) {
            throw new NullPointerException(String.format(message, values));
        }
    }

    public static void notEmpty(Object[] array) {
        Validate.notEmpty(array, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static void notEmpty(Object[] array, String message, Object ... values) {
        if (null == array) {
            throw new NullPointerException(String.format(message, values));
        }
        if (0 == array.length) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static <T extends Collection<?>> void notEmpty(T collection) {
        Validate.notEmpty(collection, DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Collection<?>> void notEmpty(T collection, String message, Object ... values) {
        if (null == collection) {
            throw new NullPointerException(String.format(message, values));
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static <T extends Map<?, ?>> void notEmpty(T map) {
        Validate.notEmpty(map, DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Map<?, ?>> void notEmpty(T map, String message, Object ... values) {
        if (null == map) {
            throw new NullPointerException(String.format(message, values));
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static <T extends CharSequence> void notEmpty(T str) {
        Validate.notEmpty(str, DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> void notEmpty(T str, String message, Object ... values) {
        if (null == str) {
            throw new NullPointerException(String.format(message, values));
        }
        if (0 == str.length()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static <T extends CharSequence> void notBlank(T str) {
        Validate.notBlank(str, DEFAULT_NOT_BLANK_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> void notBlank(T str, String message, Object ... values) {
        if (null == str) {
            throw new NullPointerException(String.format(message, values));
        }
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }
}

