/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.collection;

import com.hb0730.commons.lang.collection.ListUtils;
import com.hb0730.commons.lang.map.MapUtils;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> maps) {
        return maps == null || maps.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> maps) {
        return !CollectionUtils.isEmpty(maps);
    }

    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return null == set ? Collections.emptySet() : set;
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return null == list ? Collections.emptyList() : list;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapUtils.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        return MapUtils.newHashMap(size, isOrder);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtils.newHashMap(size);
    }

    @SafeVarargs
    public static <T> HashSet<T> set(boolean isSorted, T ... values) {
        if (null == values) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)values.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, values);
        return set;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... values) {
        return CollectionUtils.set(false, values);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... values) {
        return (LinkedHashSet)CollectionUtils.set(true, values);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<? extends T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> collection) {
        return CollectionUtils.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<? extends T> iterator) {
        HashSet set;
        if (null == iterator) {
            return CollectionUtils.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <T> List<T> list(boolean isLinked) {
        return ListUtils.list(isLinked);
    }

    public static <T> List<T> list(boolean isLinked, Collection<? extends T> collection) {
        return ListUtils.list(isLinked, collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<? extends T> iterable) {
        return ListUtils.list(isLinked, iterable);
    }

    public static <T> List<T> list(boolean isLinked, Iterator<? extends T> iter) {
        return ListUtils.list(isLinked, iter);
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        return ListUtils.list(isLinked, values);
    }

    public static <T> ArrayList<T> toArrayList(Collection<? extends T> collection) {
        return ListUtils.toArrayList(collection);
    }

    public static <T> ArrayList<T> toArrayList(Iterable<? extends T> iterable) {
        return ListUtils.toArrayList(iterable);
    }

    public static <T> ArrayList<T> toArrayList(Iterator<? extends T> iterator) {
        return ListUtils.toArrayList(iterator);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toArrayList(T ... values) {
        return ListUtils.toArrayList(values);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values) {
        return ListUtils.toLinkedList(values);
    }

    public static <T> BlockingQueue<T> toBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingQueue(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <T> BlockingQueue<T> toBlockingQueue(boolean isLinked) {
        return CollectionUtils.toBlockingQueue(16, isLinked);
    }

    public static <T> BlockingQueue<T> toArrayBlockingQueue() {
        return CollectionUtils.toBlockingQueue(16, false);
    }
}

