/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.convert;

import com.hb0730.commons.lang.ObjectUtils;
import com.hb0730.commons.lang.convert.Converter;
import com.hb0730.commons.lang.convert.exceptions.ConverterException;
import com.hb0730.commons.lang.convert.impl.BooleanConverter;
import com.hb0730.commons.lang.convert.impl.CharacterConverter;
import com.hb0730.commons.lang.convert.impl.NumberConverter;
import com.hb0730.commons.lang.convert.impl.PrimitiveConverter;
import com.hb0730.commons.lang.convert.impl.StringConverter;
import com.hb0730.commons.lang.reflect.ReflectUtils;
import com.hb0730.commons.lang.reflect.TypeUtils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConverterRegistry {
    private Map<Type, Converter<?>> defaultConverterMap;
    private volatile Map<Type, Converter<?>> customConverterMap;

    public static ConverterRegistry getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ConverterRegistry() {
        this.defaultConverter();
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) {
        Converter<T> converter;
        if (TypeUtils.isUnknow(type) && null == defaultValue) {
            return (T)value;
        }
        if (ObjectUtils.isNull(value)) {
            return defaultValue;
        }
        if (TypeUtils.isUnknow(type)) {
            type = defaultValue.getClass();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(value, defaultValue);
        }
        throw new ConverterException("No Converter for type [" + type.getTypeName() + "]");
    }

    public <T> T convert(Type type, Object value, T defaultValue) throws ConverterException {
        return this.convert(type, value, defaultValue, false);
    }

    public <T> T convert(Type type, Object value) throws ConverterException {
        return this.convert(type, value, null);
    }

    public ConverterRegistry putCustom(Type type, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(type, ReflectUtils.newInstance(converterClass, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter<?> converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Type type, boolean isCustomFirst) {
        Converter<T> converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Type type) {
        return null == type ? null : this.defaultConverterMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Type type) {
        return null == type ? null : this.customConverterMap.get(type);
    }

    public ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put((Type)((Object)Number.class), new NumberConverter());
        this.defaultConverterMap.put((Type)((Object)Integer.class), new NumberConverter(Integer.class));
        this.defaultConverterMap.put((Type)((Object)Long.class), new NumberConverter(Long.class));
        this.defaultConverterMap.put((Type)((Object)Byte.class), new NumberConverter(Byte.class));
        this.defaultConverterMap.put((Type)((Object)Short.class), new NumberConverter(Short.class));
        this.defaultConverterMap.put((Type)((Object)Float.class), new NumberConverter(Float.class));
        this.defaultConverterMap.put((Type)((Object)Double.class), new NumberConverter(Double.class));
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        return this;
    }

    private static class SingletonHolder {
        private static final ConverterRegistry INSTANCE = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

