/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.convert.impl;

import com.hb0730.commons.lang.BooleanUtils;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.convert.AbstractConverter;
import com.hb0730.commons.lang.convert.exceptions.ConverterException;
import java.util.Date;

public class NumberConverter
extends AbstractConverter<Number> {
    private final Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    protected Number convertInternal(Object value) throws ConverterException {
        try {
            return this.convertInternal(value, this.targetType);
        }
        catch (Exception e) {
            throw new ConverterException("convert fail", e);
        }
    }

    private Number convertInternal(Object value, Class<?> targetType) throws NumberFormatException {
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toByteObj((Boolean)value);
            }
            String valueStr = this.toStr(value);
            return StringUtils.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
        }
        if (Short.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toShortObj((Boolean)value);
            }
            String valueStr = this.toStr(value);
            return StringUtils.isBlank(valueStr) ? null : Short.valueOf(valueStr);
        }
        if (Integer.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toInteger((Boolean)value);
            }
            String valueStr = this.toStr(value);
            return StringUtils.isBlank(valueStr) ? null : Integer.valueOf(valueStr);
        }
        if (Long.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toLongObj((Boolean)value);
            }
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            String valueStr = this.toStr(value);
            return StringUtils.isBlank(valueStr) ? null : Long.valueOf(valueStr);
        }
        if (Float.class == targetType) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toFloatObj((Boolean)value);
            }
            String valueStr = this.toStr(value);
            return StringUtils.isBlank(valueStr) ? null : Float.valueOf(valueStr);
        }
        if (Double.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toDoubleObj((Boolean)value);
            }
            String valueStr = this.toStr(value);
            return StringUtils.isBlank(valueStr) ? null : Double.valueOf(valueStr);
        }
        throw new UnsupportedOperationException(String.format("Unsupport Number type: %s", this.targetType.getName()));
    }
}

