/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.nums;

import com.hb0730.commons.lang.StringUtils;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_LETTER = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String BASE_CHAR = "=/+-*_~!#@%^&()|.`:";
    public static final String BASE_LETTER_NUMBER = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String BASE_CHAR_LETTER_NUMBER = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ=/+-*_~!#@%^&()|.`:";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static String randomNumber(int length) {
        return RandomUtils.randomString(BASE_NUMBER, length);
    }

    public static String randomString(int length, boolean withNumber) {
        if (withNumber) {
            return RandomUtils.randomString(BASE_LETTER_NUMBER, length);
        }
        return RandomUtils.randomString(BASE_LETTER, length);
    }

    public static String randomStringWithSpecialChar(int length) {
        return RandomUtils.randomString(BASE_CHAR_LETTER_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (StringUtils.isBlank(baseString)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtils.randomInt(baseLength);
            builder.append(baseString.charAt(number));
        }
        return builder.toString();
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static int randomInt(int min, int max) {
        return RandomUtils.getRandom().nextInt(min, max);
    }

    public static int randomInt(int limit) {
        return RandomUtils.getRandom().nextInt(limit);
    }

    public static int randomInt() {
        return RandomUtils.getRandom().nextInt();
    }
}

