/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.runtime;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class SystemUtils {
    private static AtomicInteger shutdownHookThreadIndex = new AtomicInteger(0);

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static String getLineSeparator() {
        return SystemUtils.getProperty("line.separator");
    }

    public static int getPid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = jvmName.split("@");
        if (split.length != 2) {
            return -1;
        }
        return Integer.parseInt(split[0]);
    }

    public static long getUpTime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public static List<String> getRuntimeArgs() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static void addShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable, "Thread-ShutDownHook" + shutdownHookThreadIndex.incrementAndGet()));
    }
}

