/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang;

import com.hb0730.commons.lang.collection.ArrayUtils;
import com.hb0730.commons.lang.convert.BasicTypeEnum;
import com.hb0730.commons.lang.reflect.TypeUtils;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class ClassUtils {
    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive() && !ClassUtils.isAbstract(clazz);
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtils.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeUtils.getTypeArgument(clazz, index);
        if (argumentType instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    public static boolean isBasicClass(Class<?> clazz) {
        boolean isPrimitive = false;
        try {
            if (clazz.isPrimitive() || clazz.isAssignableFrom(String.class)) {
                return true;
            }
            isPrimitive = ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            isPrimitive = false;
        }
        return isPrimitive;
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtils.isBasicClass(clazz);
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtils.isEmpty(types1) && ArrayUtils.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassUtils.isBasicType(type1) && ClassUtils.isBasicType(type2) ? BasicTypeEnum.unWrap(type1) != BasicTypeEnum.unWrap(type2) : !type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }
}

