/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang;

import com.hb0730.commons.lang.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class RegexUtils {
    public static boolean find(String str, String regex) {
        return Pattern.compile(regex).matcher(str).find();
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (StringUtils.isBlank(regex) || null == content) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexUtils.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static boolean isEmail(String email) {
        return Pattern.matches("\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?", email);
    }

    public static boolean isZH(String chinese) {
        return Pattern.matches("^[\u4e00-\u9fa5]+$", chinese);
    }

    public static boolean isChineseIdCard(String idCard) {
        return Pattern.matches("[1-9]\\d{13,16}[a-zA-Z0-9]{1}", idCard);
    }

    public static boolean isMobile(String mobile) {
        return Pattern.matches("^(1)\\d{10}$", mobile);
    }

    public static boolean isPhone(String phone) {
        return Pattern.matches("(\\+\\d+)?(\\d{3,4}\\-?)?\\d{7,8}$", phone);
    }

    public static boolean isDigit(String digit) {
        return Pattern.matches("\\-?[1-9]\\d+", digit);
    }

    public static boolean isDecimals(String decimals) {
        return Pattern.matches("\\-?[1-9]\\d+(\\.\\d+)?", decimals);
    }

    public static boolean isBlank(String space) {
        return Pattern.matches("\\s+", space);
    }

    public static boolean isBirthday(String birthday) {
        return Pattern.matches("^\\d{4}(-|/|.)\\d{1,2}\\1\\d{1,2}$", birthday);
    }

    public static boolean isURL(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static boolean isChinaPostCode(String value) {
        Pattern pattern = Pattern.compile("[1-9]\\d{5}");
        return RegexUtils.isMatch(pattern, (CharSequence)value);
    }

    public static boolean isHex(String value) {
        Pattern pattern = Pattern.compile("^[a-f0-9]+$", 2);
        return RegexUtils.isMatch(pattern, (CharSequence)value);
    }
}

