/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.codec;

import com.hb0730.commons.lang.Charsets;
import java.nio.charset.Charset;

public class HexUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeHexString(String data) {
        return HexUtils.encodeHexString(data, com.hb0730.commons.lang.constants.Charsets.UTF_8);
    }

    public static String encodeHexString(String data, String charset) {
        return HexUtils.encodeHexString(data, Charsets.toCharset(charset));
    }

    public static String encodeHexString(String data, Charset charset) {
        return HexUtils.encodeHexString(data, charset, true);
    }

    public static String encodeHexString(String data, Charset charset, boolean toLowerCase) {
        return HexUtils.encodeHexString(data.getBytes(charset), toLowerCase);
    }

    public static String encodeHexString(byte[] data) {
        return HexUtils.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static char[] encodeHex(String data) {
        return HexUtils.encodeHex(data, com.hb0730.commons.lang.constants.Charsets.UTF_8);
    }

    public static char[] encodeHex(String data, Charset charset) {
        return HexUtils.encodeHex(data, charset, true);
    }

    public static char[] encodeHex(String data, Charset charset, boolean toLowerCase) {
        return HexUtils.encodeHex(data.getBytes(charset), toLowerCase);
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decodeHexStr(String data) {
        return HexUtils.decodeHexStr(data, com.hb0730.commons.lang.constants.Charsets.UTF_8);
    }

    public static String decodeHexStr(String data, Charset charset) {
        return HexUtils.decodeHexStr(data.toCharArray(), charset);
    }

    public static String decodeHexStr(char[] data) {
        return HexUtils.decodeHexStr(data, com.hb0730.commons.lang.constants.Charsets.UTF_8);
    }

    public static String decodeHexStr(char[] data, Charset charset) {
        return new String(HexUtils.decodeHex(data), charset);
    }

    public static byte[] decodeHex(String data) {
        return HexUtils.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(data[j], j) << 4;
            f |= HexUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static String encodeHexString(byte[] data, char[] toDigits) {
        return new String(HexUtils.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

