/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.date;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.Validate;
import com.hb0730.commons.lang.date.DateMsUnit;
import com.hb0730.commons.lang.date.LocalDateTimeUtils;
import com.hb0730.commons.lang.date.TemporalAccessorUtils;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    public static final String FORMAT_DEFAULT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_DEFAULT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_ZONE = "GMT+8";

    public static Date now() {
        return new Date();
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, FORMAT_DEFAULT_DATE);
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, FORMAT_DEFAULT_DATETIME);
    }

    public static String formatDate(Date date, String format) {
        return DateUtils.formatDate(date, format, TimeZone.getTimeZone(TIME_ZONE));
    }

    public static String formatDate(Date date, String format, TimeZone timeZone) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence date, String format) {
        return LocalDateTimeUtils.parse(date, format);
    }

    public static Date toDate(String date) throws ParseException {
        return DateUtils.toDate(date, FORMAT_DEFAULT_DATE);
    }

    public static Date toDateTime(String date) throws ParseException {
        return DateUtils.toDate(date, FORMAT_DEFAULT_DATETIME);
    }

    public static Date toDate(String date, String format) throws ParseException {
        return DateUtils.toDate(date, format, TimeZone.getTimeZone(TIME_ZONE));
    }

    public static Date toDate(String date, String format, TimeZone timeZone) throws ParseException {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.parse(date);
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtils.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTimeUtils.of(instant);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTimeUtils.of(date);
    }

    public static Date add(Date date, long time, TimeUnit timeUnit) {
        Date result;
        if (null == date || time < 0L || timeUnit == null) {
            return null;
        }
        int timeIntValue = time > Integer.MAX_VALUE ? Integer.MAX_VALUE : Long.valueOf(time).intValue();
        switch (timeUnit) {
            case DAYS: {
                result = DateUtils.addDays(date, timeIntValue);
                break;
            }
            case HOURS: {
                result = DateUtils.addHours(date, timeIntValue);
                break;
            }
            case MINUTES: {
                result = DateUtils.addMinutes(date, timeIntValue);
                break;
            }
            case SECONDS: {
                result = DateUtils.addSeconds(date, timeIntValue);
                break;
            }
            case MILLISECONDS: {
                result = DateUtils.addMilliseconds(date, timeIntValue);
                break;
            }
            default: {
                result = date;
            }
        }
        return result;
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateUtils.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        DateUtils.validateDateNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    private static void validateDateNotNull(Date date) {
        Validate.isTrue(date != null, "The date must not be null", new Object[0]);
    }

    public static long between(Date startDate, Date endDate, DateMsUnit msUnit) {
        return DateUtils.between(startDate, endDate, msUnit, true);
    }

    public static long between(Date startDate, Date endDate, DateMsUnit msUnit, boolean isAbs) {
        Validate.notNull(startDate, "start date must not null", new Object[0]);
        Validate.notNull(endDate, "end date must not null", new Object[0]);
        Validate.notNull((Object)msUnit, "time unit must not null", new Object[0]);
        Date begin = startDate;
        Date end = endDate;
        if (isAbs && begin.after(end)) {
            begin = end;
            end = startDate;
        }
        long diff = end.getTime() - begin.getTime();
        return diff / msUnit.getMillis();
    }

    public static Date getServerStartDate() {
        long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(startTime);
    }

    public static Calendar convertTo(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static boolean isAfter(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            return false;
        }
        return date1.after(date2);
    }

    public static boolean isAfter(Date date) {
        return DateUtils.isAfter(date, DateUtils.now());
    }

    public static boolean isBefore(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            return false;
        }
        return date1.before(date2);
    }

    public static boolean isBefore(Date date) {
        return DateUtils.isBefore(date, new Date());
    }
}

