/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.date;

import com.hb0730.commons.lang.ObjectUtils;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.date.TemporalAccessorUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.TimeZone;

public class LocalDateTimeUtils {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        if (null == instant) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, ObjectUtils.defaultIfNull(zoneId, ZoneId.systemDefault()));
    }

    public static LocalDateTime of(Instant instant, String zone) {
        ZoneId zoneId = StringUtils.isBlank(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        return LocalDateTimeUtils.of(instant, zoneId);
    }

    public static LocalDateTime of(Instant instant) {
        return LocalDateTimeUtils.of(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime of(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime of(Instant instant, TimeZone timeZone) {
        return LocalDateTimeUtils.of(instant, ObjectUtils.defaultIfNull(timeZone, TimeZone.getDefault()).toZoneId());
    }

    public static LocalDateTime of(long epochMilli, TimeZone timeZone) {
        return LocalDateTimeUtils.of(Instant.ofEpochMilli(epochMilli), timeZone);
    }

    public static LocalDateTime of(long epochMilli, String timeZone) {
        TimeZone zone = StringUtils.isBlank(timeZone) ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZone);
        return LocalDateTimeUtils.of(epochMilli, zone);
    }

    public static LocalDateTime of(long epochMilli) {
        return LocalDateTimeUtils.of(epochMilli, TimeZone.getDefault());
    }

    public static LocalDateTime of(Date date) {
        if (null == date) {
            return null;
        }
        return LocalDateTimeUtils.of(date.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        return LocalDateTime.of(TemporalAccessorUtils.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtils.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtils.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtils.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtils.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parse(CharSequence datetime, DateTimeFormatter formatter) {
        if (null == datetime) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(datetime);
        }
        return LocalDateTimeUtils.of(formatter.parse(datetime));
    }

    public static LocalDateTime parse(CharSequence datetime) {
        return LocalDateTimeUtils.parse(datetime, (DateTimeFormatter)null);
    }

    public static LocalDateTime parse(CharSequence datetime, String format) {
        if (null == datetime) {
            return null;
        }
        return LocalDateTimeUtils.parse(datetime, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate parseDate(CharSequence date, DateTimeFormatter formatter) {
        if (null == date) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(date);
        }
        return LocalDateTimeUtils.ofDate(formatter.parse(date));
    }

    public static LocalDate parseDate(CharSequence date) {
        return LocalDateTimeUtils.parseDate(date, (DateTimeFormatter)null);
    }

    public static LocalDate parseDate(CharSequence date, String format) {
        return LocalDateTimeUtils.parseDate(date, DateTimeFormatter.ofPattern(format));
    }

    public static String format(LocalDateTime dateTime, DateTimeFormatter formatter) {
        return TemporalAccessorUtils.format((TemporalAccessor)dateTime, formatter);
    }

    public static String format(LocalDateTime dateTime, String format) {
        return LocalDateTimeUtils.format(dateTime, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        if (null == time) {
            return null;
        }
        return time.plus(number, field);
    }

    public static Duration between(LocalDateTime startTime, LocalDateTime endTime) {
        return Duration.between(startTime, endTime);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.of(0, 0, 0, 0));
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        return time.with(LocalTime.of(23, 59, 59, 999999999));
    }
}

