/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.io;

import com.hb0730.commons.lang.Charsets;
import com.hb0730.commons.lang.Validate;
import com.hb0730.commons.lang.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class FileUtils {
    public static void write(File file, CharSequence content, String encoding) throws IOException {
        FileUtils.write(file, content, encoding, false);
    }

    public static void write(File file, CharSequence content, String encoding, boolean append) throws IOException {
        FileUtils.write(file, content, Charsets.toCharset(encoding), append);
    }

    public static void write(File file, CharSequence content, Charset encoding) throws IOException {
        FileUtils.write(file, content, encoding, false);
    }

    public static void write(File file, CharSequence content, Charset encoding, boolean append) throws IOException {
        String str = content == null ? null : content.toString();
        FileUtils.writeString(file, str, encoding, append);
    }

    public static void writeString(File file, String content, String encoding) throws IOException {
        FileUtils.writeString(file, content, encoding, false);
    }

    public static void writeString(File file, String content, String encoding, boolean append) throws IOException {
        FileUtils.writeString(file, content, Charsets.toCharset(encoding), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String content, Charset encoding, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            IOUtils.write(content, (OutputStream)out, encoding);
            ((OutputStream)out).close();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void writeByteArray(File file, byte[] content) throws IOException {
        FileUtils.writeByteArray(file, content, false);
    }

    public static void writeByteArray(File file, byte[] content, boolean append) throws IOException {
        FileUtils.writeByteArray(file, content, 0, content.length, append);
    }

    public static void writeByteArray(File file, byte[] content, int off, int len) throws IOException {
        FileUtils.writeByteArray(file, content, off, len, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArray(File file, byte[] content, int off, int len, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            ((OutputStream)out).write(content, off, len);
            ((OutputStream)out).close();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        Validate.notNull(file, "file must be not null", new Object[0]);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static boolean forceDeletePath(File path) {
        if (null == path) {
            return false;
        }
        if (path.exists() && path.isDirectory()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.forceDeletePath(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }
}

