/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ModifierUtils {
    public static boolean hasModifier(Class<?> clazz, ModifierType modifierType) {
        if (null == clazz || null == modifierType) {
            return false;
        }
        return 0 != (clazz.getModifiers() & modifierType.value);
    }

    public static boolean hasModifier(Constructor<?> constructor, ModifierType modifierType) {
        if (null == constructor || null == modifierType) {
            return false;
        }
        return 0 != (constructor.getModifiers() & modifierType.value);
    }

    public static boolean hasModifier(Method method, ModifierType modifierType) {
        if (null == method || null == modifierType) {
            return false;
        }
        return 0 != (method.getModifiers() & modifierType.value);
    }

    public static boolean hasModifier(Field field, ModifierType modifierType) {
        if (null == field || null == modifierType) {
            return false;
        }
        return 0 != (field.getModifiers() & modifierType.value);
    }

    public static boolean isPublic(Field field) {
        return ModifierUtils.hasModifier(field, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Method method) {
        return ModifierUtils.hasModifier(method, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Constructor<?> constructor) {
        return ModifierUtils.hasModifier(constructor, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Class<?> clazz) {
        return ModifierUtils.hasModifier(clazz, ModifierType.PUBLIC);
    }

    public static boolean isStatic(Field field) {
        return ModifierUtils.hasModifier(field, ModifierType.STATIC);
    }

    public static boolean isStatic(Method method) {
        return ModifierUtils.hasModifier(method, ModifierType.STATIC);
    }

    public static boolean isStatic(Class<?> clazz) {
        return ModifierUtils.hasModifier(clazz, ModifierType.STATIC);
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZE(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        INTERFACE(512),
        ABSTRACT(1024),
        STRICT(2048);

        private final int value;

        private ModifierType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

