/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ObjectUtils {
    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return !ObjectUtils.isNull(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return 0 == Array.getLength(obj);
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectUtils.isEmpty(obj);
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return null == value ? defaultValue : value;
    }

    public static boolean equal(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    public static boolean notEqual(Object o1, Object o2) {
        return !ObjectUtils.equal(o1, o2);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static int length(Object obj) {
        if (null == obj) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int compare(T t1, T t2) {
        return ObjectUtils.compare(t1, t2, false);
    }

    public static <T extends Comparable<? super T>> int compare(T t1, T t2, boolean nullGreater) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 == null) {
            return nullGreater ? 1 : -1;
        }
        if (t2 == null) {
            return nullGreater ? -1 : 1;
        }
        return t1.compareTo(t2);
    }
}

