/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.bean;

import com.hb0730.commons.lang.bean.BeanException;
import com.hb0730.commons.lang.bean.BeanInfoCache;
import com.hb0730.commons.lang.reflect.ReflectUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanUtils {
    public static Object deepClone(Object objSource) throws IllegalAccessException, InstantiationException {
        if (null == objSource) {
            return null;
        }
        Class<?> clazz = objSource.getClass();
        Object objDes = clazz.newInstance();
        List<Field> fields = ReflectUtils.getFields(clazz, true);
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getModifiers() >= 24) continue;
            try {
                field.set(objDes, field.get(objSource));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objDes;
    }

    public static PropertyDescriptor[] getPropertyDescriptor(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new BeanException(e);
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> descriptorMap = BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase);
        if (null == descriptorMap) {
            descriptorMap = BeanUtils.internalGetPropertyDescriptorMap(clazz, ignoreCase);
            BeanInfoCache.INSTANCE.putPropertyDescriptorMap(clazz, descriptorMap, ignoreCase);
        }
        return descriptorMap;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanUtils.getPropertyDescriptorMap(clazz, ignoreCase);
        return ignoreCase ? map.get(fieldName.toLowerCase()) : map.get(fieldName);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanUtils.getPropertyDescriptor(clazz, fieldName, false);
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptor(clazz);
        ConcurrentHashMap<String, PropertyDescriptor> map = new ConcurrentHashMap<String, PropertyDescriptor>(propertyDescriptors.length, 1.0f);
        if (ignoreCase) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                map.put(propertyDescriptor.getName().toLowerCase(), propertyDescriptor);
            }
        } else {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                map.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        return map;
    }
}

