/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.codec;

import com.hb0730.commons.lang.constants.Charsets;
import java.nio.charset.Charset;
import java.util.Base64;

public class Base64Utils {
    public static byte[] encode(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return Base64.getEncoder().encode(src);
    }

    public static byte[] decode(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return Base64.getDecoder().decode(src);
    }

    public static byte[] encodeUrlSafe(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return Base64.getUrlEncoder().encode(src);
    }

    public static byte[] decodeUrlSafe(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return Base64.getUrlDecoder().decode(src);
    }

    public static String encodeToString(byte[] src, Charset charset) {
        if (src.length == 0) {
            return "";
        }
        return new String(Base64Utils.encode(src), charset);
    }

    public static String encodeToString(byte[] src, String charset) {
        return Base64Utils.encodeToString(src, Charset.forName(charset));
    }

    public static String encodeToString(byte[] src) {
        return Base64Utils.encodeToString(src, Charsets.UTF_8);
    }

    public static byte[] decodeFromString(String src, Charset charset) {
        if (src.isEmpty()) {
            return new byte[0];
        }
        return Base64Utils.decode(src.getBytes(charset));
    }

    public static byte[] decodeFromString(String src, String charset) {
        return Base64Utils.decodeFromString(src, Charset.forName(charset));
    }

    public static byte[] decodeFromString(String src) {
        return Base64Utils.decodeFromString(src, Charsets.UTF_8);
    }

    public static String encodeToUrlSafeString(byte[] src, Charset charset) {
        return new String(Base64Utils.encodeUrlSafe(src), charset);
    }

    public static String encodeToUrlSafeString(byte[] src, String charset) {
        return Base64Utils.encodeToUrlSafeString(src, Charset.forName(charset));
    }

    public static String encodeToUrlSafeString(byte[] src) {
        return Base64Utils.encodeToUrlSafeString(src, Charsets.UTF_8);
    }

    public static byte[] decodeFromUrlSafeString(String src, Charset charset) {
        return Base64Utils.decodeUrlSafe(src.getBytes(charset));
    }

    public static byte[] decodeFromUrlSafeString(String src, String charset) {
        return Base64Utils.decodeFromUrlSafeString(src, Charset.forName(charset));
    }

    public static byte[] decodeFromUrlSafeString(String src) {
        return Base64Utils.decodeFromUrlSafeString(src, Charsets.UTF_8);
    }
}

