/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.collection;

import com.hb0730.commons.lang.ObjectUtils;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.collection.ListUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    public static <T> boolean isEmpty(T[] array) {
        return null == array || array.length == 0;
    }

    public static boolean isEmpty(Object obj) {
        if (null != obj && ArrayUtils.isArray(obj)) {
            return 0 == Array.getLength(obj);
        }
        return true;
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayUtils.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isArraySameLength(Object[] array1, Object[] array2) {
        int len1 = ArrayUtils.isEmpty(array1) ? 0 : Array.getLength(array1);
        int len2 = ArrayUtils.isEmpty(array2) ? 0 : Array.getLength(array2);
        return len1 == len2;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length > 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> void arrayReverse(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            T temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }

    public static <T> boolean hashNull(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T fistNonNullEl(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            for (T element : array) {
                if (null == element) continue;
                return element;
            }
        }
        return null;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtils.arrayIndexOf(array, value, 0) > -1;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtils.arrayIndexOfIgnoreCase(array, value) > -1;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        for (T value : values) {
            if (!ArrayUtils.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> int arrayIndexOf(T[] array, Object value) {
        return ArrayUtils.arrayIndexOf(array, value, 0);
    }

    public static <T> int arrayIndexOf(T[] array, Object value, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        } else if (startIndex > array.length) {
            return -1;
        }
        if (value == null) {
            for (int i = 0; i < array.length; ++i) {
                if (null != array[i]) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!ObjectUtils.equal(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int arrayIndexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtils.arrayIndexOfIgnoreCase(array, value, 0);
    }

    public static int arrayIndexOfIgnoreCase(CharSequence[] array, CharSequence value, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        } else if (startIndex > array.length) {
            return -1;
        }
        if (value == null) {
            for (int i = 0; i < array.length; ++i) {
                if (null != array[i]) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!StringUtils.equals(value, array[i], true)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int arrayLastIndexOf(T[] array, Object value) {
        return ArrayUtils.arrayLastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static <T> int arrayLastIndexOf(T[] array, Object value, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (value == null) {
            for (int i = array.length - 1; i >= startIndex; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = array.length - 1; i >= startIndex; --i) {
                if (!ObjectUtils.equal(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T get(Object[] array, int index) {
        if (null == array) {
            return null;
        }
        if (index < 0) {
            index = 0;
        } else if (index >= array.length) {
            index = array.length - 1;
        }
        return (T)Array.get(array, index);
    }

    public static <T> T[] get(Object[] array, int ... indexes) {
        if (null == array) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = ArrayUtils.get(array, indexes[i]);
        }
        return result;
    }

    public static <T> T[] remove(T[] array, int index) {
        return (Object[])ArrayUtils.remove(array, index);
    }

    public static Object remove(Object array, int index) {
        if (!ArrayUtils.isArray(array)) {
            return array;
        }
        int len = Array.getLength(array);
        if (index < 0 || index >= len) {
            return array;
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), len - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < len - 1) {
            System.arraycopy(array, index + 1, result, index, len - index - 1);
        }
        return result;
    }

    public static <T> T[] removeEl(T[] array, T element) {
        return ArrayUtils.remove(array, ArrayUtils.arrayIndexOf(array, element));
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return set.toArray(ArrayUtils.newArray(array.getClass().getComponentType(), 0));
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] newArray(Collection<? extends T> col, Class<T> componentType) {
        return col.toArray((Object[])Array.newInstance(componentType, 0));
    }

    public static void swap(Object[] array, int i, int j) {
        Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence divider) {
        return ArrayUtils.join(array, divider, null, null, 0);
    }

    public static <T> String join(T[] array, CharSequence divider, String prefix, String suffix, int length) {
        if (null == array) {
            return null;
        }
        if (length <= 0 || ArrayUtils.length(array) < length) {
            length = ArrayUtils.length(array);
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int i = 0; i < length; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(divider);
            }
            sb.append(StringUtils.joinNotNull(prefix, array[i].toString(), suffix));
        }
        return sb.toString();
    }

    public static <T> List<T> toList(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return null;
        }
        return ListUtils.toArrayList(array);
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtils.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayUtils.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtils.isNotEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ArrayUtils.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtils.isNotEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static String toString(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        if (value instanceof short[]) {
            return Arrays.toString((short[])value);
        }
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        if (value instanceof char[]) {
            return Arrays.toString((char[])value);
        }
        if (value instanceof long[]) {
            return Arrays.toString((long[])value);
        }
        if (value instanceof boolean[]) {
            return Arrays.toString((boolean[])value);
        }
        if (value instanceof float[]) {
            return Arrays.toString((float[])value);
        }
        if (value instanceof double[]) {
            return Arrays.toString((double[])value);
        }
        if (ArrayUtils.isArray(value)) {
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }
}

