/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.collection;

import com.hb0730.commons.lang.builder.Builder;
import java.util.Collection;
import java.util.List;

public class ListBuilder<E>
implements Builder<List<E>> {
    private final List<E> list;

    public static <E> ListBuilder<E> build(List<E> list) {
        return new ListBuilder<E>(list);
    }

    public ListBuilder(List<E> list) {
        this.list = list;
    }

    public ListBuilder<E> add(E e) {
        this.list.add(e);
        return this;
    }

    public ListBuilder<E> add(int index, E e) {
        this.list.add(index, e);
        return this;
    }

    public ListBuilder<E> addAll(Collection<? extends E> elements) {
        this.list.addAll(elements);
        return this;
    }

    public ListBuilder<E> addAll(int index, Collection<? extends E> elements) {
        this.list.addAll(index, elements);
        return this;
    }

    public ListBuilder<E> remove(E e) {
        this.list.remove(e);
        return this;
    }

    public ListBuilder<E> remove(int index) {
        this.list.remove(index);
        return this;
    }

    public ListBuilder<E> removeAll(Collection<? extends E> elements) {
        this.list.removeAll(elements);
        return this;
    }

    @Override
    public List<E> build() {
        return this.list;
    }
}

