/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.collection;

import com.hb0730.commons.lang.collection.ArrayUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ListUtils {
    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    public static <T> List<T> list(boolean isLinked, Collection<? extends T> collection) {
        if (null == collection) {
            return ListUtils.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return ListUtils.list(isLinked);
        }
        AbstractList list = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(list, values);
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Iterable<? extends T> iterable) {
        if (null == iterable) {
            return ListUtils.list(isLinked);
        }
        return ListUtils.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<? extends T> iter) {
        List<T> list = ListUtils.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(Enumeration<T> enumeration) {
        return ListUtils.list(false, enumeration);
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumeration) {
        List<T> data = ListUtils.list(isLinked);
        if (null != enumeration) {
            while (enumeration.hasMoreElements()) {
                data.add(enumeration.nextElement());
            }
        }
        return data;
    }

    public static <T> ArrayList<T> toArrayList(Collection<? extends T> collection) {
        return (ArrayList)ListUtils.list(false, collection);
    }

    public static <T> ArrayList<T> toArrayList(Iterable<? extends T> iterable) {
        return (ArrayList)ListUtils.list(false, iterable);
    }

    public static <T> ArrayList<T> toArrayList(Iterator<? extends T> iterator) {
        return (ArrayList)ListUtils.list(false, iterator);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toArrayList(T ... values) {
        return (ArrayList)ListUtils.list(false, values);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values) {
        return (LinkedList)ListUtils.list(true, values);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        list.sort(c);
        return list;
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }
}

