/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.convert;

import com.hb0730.commons.lang.CharUtils;
import com.hb0730.commons.lang.ClassUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;
import com.hb0730.commons.lang.convert.Converter;
import com.hb0730.commons.lang.convert.exceptions.ConverterException;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractConverter<T>
implements Converter<T> {
    public T convertQuietly(Object value, T defaultValue) {
        try {
            return this.convert(value, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public T convert(Object value, T defaultValue) throws ConverterException {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(String.format("[type] and [defaultValue] are both null for Converter [%s],we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            T result = this.convertInternal(value);
            if (null == result) {
                return defaultValue;
            }
            if (result instanceof Optional) {
                if (!((Optional)result).isPresent()) {
                    return defaultValue;
                }
                return result;
            }
            return result;
        }
        throw new ConverterException(String.format("Default value [%s](%s) is not the instance of [%s]", defaultValue, defaultValue.getClass(), targetType));
    }

    protected abstract T convertInternal(Object var1) throws ConverterException;

    protected String toStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtils.isArray(value)) {
            return ArrayUtils.toString(value);
        }
        if (CharUtils.isChar(value)) {
            return CharUtils.toString(((Character)value).charValue());
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtils.getTypeArgument(this.getClass());
    }
}

