/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.convert.impl;

import com.hb0730.commons.lang.BooleanUtils;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.convert.AbstractConverter;
import java.util.Date;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private final Class<?> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object value) {
        try {
            if (Byte.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtils.toByte((Boolean)value);
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Byte.parseByte(str);
            }
            if (Short.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtils.toShort((Boolean)value);
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Short.parseShort(str);
            }
            if (Integer.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtils.toInt((Boolean)value);
                }
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Integer.parseInt(str);
            }
            if (Long.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtils.toLong((Boolean)value);
                }
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Long.parseLong(str);
            }
            if (Float.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof Boolean) {
                    return Float.valueOf(BooleanUtils.toFloat((Boolean)value));
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Float.valueOf(Float.parseFloat(str));
            }
            if (Double.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof Boolean) {
                    return BooleanUtils.toDouble((Boolean)value);
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Double.parseDouble(str);
            }
            if (Character.TYPE == this.targetType) {
                if (value instanceof Character) {
                    return Character.valueOf(((Character)value).charValue());
                }
                if (value instanceof Boolean) {
                    return Character.valueOf(BooleanUtils.toChar((Boolean)value));
                }
                String str = this.toStr(value);
                if (StringUtils.isBlank(str)) {
                    return 0;
                }
                return Character.valueOf(str.charAt(0));
            }
            if (Boolean.TYPE == this.targetType) {
                if (value instanceof Boolean) {
                    return (boolean)((Boolean)value);
                }
                String valueStr = this.toStr(value);
                return BooleanUtils.toBoolean(valueStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }
}

