/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.date;

import com.hb0730.commons.lang.StringUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.TimeZone;

public class LocalDateUtils {
    public static LocalDate now() {
        return LocalDateUtils.now(ZoneId.systemDefault());
    }

    public static LocalDate now(String zoneId) {
        ZoneId id;
        if (StringUtils.isBlank(zoneId)) {
            id = ZoneId.systemDefault();
        } else {
            TimeZone zone = TimeZone.getTimeZone(zoneId);
            id = zone.toZoneId();
        }
        return LocalDateUtils.now(id);
    }

    public static LocalDate now(ZoneId zoneId) {
        if (null == zoneId) {
            zoneId = ZoneId.systemDefault();
        }
        return LocalDate.now(zoneId);
    }

    public static LocalDate of(int year, int moth, int day) {
        return LocalDate.of(year, moth, day);
    }
}

