/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.io;

import com.hb0730.commons.lang.Charsets;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.Validate;
import com.hb0730.commons.lang.collection.ListUtils;
import com.hb0730.commons.lang.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static File getFile(String filepath) {
        return StringUtils.isBlank(filepath) ? null : new File(filepath);
    }

    public static boolean isFileExists(File file) {
        return null != file && file.exists();
    }

    public static boolean isFileExists(String filepath) {
        return FileUtils.isFileExists(FileUtils.getFile(filepath));
    }

    public static boolean rename(String filepath, String newName) {
        return FileUtils.rename(FileUtils.getFile(filepath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (!FileUtils.isFileExists(file) || StringUtils.isBlank(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean isDir(String dirPath) {
        return FileUtils.isDir(FileUtils.getFile(dirPath));
    }

    public static boolean isDir(File file) {
        return FileUtils.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filepath) {
        return FileUtils.isFile(FileUtils.getFile(filepath));
    }

    public static boolean isFile(File file) {
        return FileUtils.isFileExists(file) && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFile(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return null != file && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) throws IOException {
        return FileUtils.createOrExistsFile(FileUtils.getFile(filePath));
    }

    public static boolean createOrExistsFile(File file) throws IOException {
        if (null == file) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        return FileUtils.createOrExistsDir(file.getParentFile()) && file.createNewFile();
    }

    public static boolean createFileByDeleteOldFile(String filePath) throws IOException {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFile(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isFile() && !file.delete()) {
            return false;
        }
        return FileUtils.createOrExistsDir(file.getParentFile()) && file.createNewFile();
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtils.deleteDir(FileUtils.getFile(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (null == dir) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        FileUtils.deleteFilesInDir(dir);
        return dir.delete();
    }

    public static boolean deleteFile(String filepath) {
        return FileUtils.deleteFile(FileUtils.getFile(filepath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFile(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (null != files && files.length > 0) {
            for (File file : files) {
                if (file.isFile() && !FileUtils.deleteFile(file)) {
                    return false;
                }
                if (!file.isDirectory() || FileUtils.deleteDir(file)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFile(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        if (!FileUtils.isDir(dir)) {
            return null;
        }
        if (isRecursive) {
            return FileUtils.listFilesInDir(dir);
        }
        File[] files = dir.listFiles();
        return ListUtils.toArrayList(files);
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(FileUtils.getFile(dirPath));
    }

    public static List<File> listFilesInDir(File dir) {
        if (null == dir) {
            return null;
        }
        File[] files = dir.listFiles();
        if (FileUtils.isDir(dir) && null != files) {
            ArrayList<File> list = new ArrayList<File>(files.length);
            if (files.length > 0) {
                for (File file : files) {
                    List<File> fileList;
                    list.add(file);
                    if (!file.isDirectory() || null == (fileList = FileUtils.listFilesInDir(file))) continue;
                    list.addAll(fileList);
                }
            }
            return list;
        }
        return null;
    }

    public static List<File> listFilesInDirWithSuffix(String dirPath, String suffix, boolean isRecursive) {
        return FileUtils.listFilesInDirWithSuffix(FileUtils.getFile(dirPath), suffix, isRecursive);
    }

    public static List<File> listFilesInDirWithSuffix(File dir, String suffix, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDirWithSuffix(dir, suffix);
        }
        if (null == dir || !FileUtils.isDir(dir)) {
            return null;
        }
        File[] files = dir.listFiles();
        if (null != files && files.length > 0) {
            ArrayList<File> list = new ArrayList<File>(files.length);
            for (File file : files) {
                if (null == suffix || !file.getName().toUpperCase().endsWith(suffix.toUpperCase())) continue;
                list.add(file);
            }
            return list;
        }
        return null;
    }

    public static List<File> listFilesInDirWithSuffix(String dirPath, String suffix) {
        return FileUtils.listFilesInDirWithSuffix(FileUtils.getFile(dirPath), suffix);
    }

    public static List<File> listFilesInDirWithSuffix(File dir, String suffix) {
        if (null == dir || !FileUtils.isDir(dir)) {
            return null;
        }
        List<File> list = ListUtils.list(false);
        File[] files = dir.listFiles();
        if (null != files && files.length > 0) {
            for (File file : files) {
                if (null != suffix && file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithSuffix(file, suffix));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFile(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDirWithFilter(dir, filter);
        }
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            List<File> list = ListUtils.list(false);
            for (File file : files) {
                if (null == filter || !filter.accept(file.getParentFile(), file.getName())) continue;
                list.add(file);
            }
            return list;
        }
        return null;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFile(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter) {
        if (null == dir || !FileUtils.isDir(dir)) {
            return ListUtils.list(false);
        }
        File[] files = dir.listFiles();
        if (null != files && files.length > 0) {
            ArrayList<File> list = new ArrayList<File>(files.length);
            for (File file : files) {
                if (null != filter && filter.accept(file.getParentFile(), file.getName())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, filter));
            }
            return list;
        }
        return ListUtils.list(false);
    }

    public static List<File> searchFileInDir(String dirPath, String filename) {
        return FileUtils.searchFileInDir(FileUtils.getFile(dirPath), filename);
    }

    public static List<File> searchFileInDir(File dir, String filename) {
        if (null == dir || !FileUtils.isDir(dir)) {
            return ListUtils.list(false);
        }
        File[] files = dir.listFiles();
        if (null != files && files.length > 0) {
            ArrayList<File> list = new ArrayList<File>();
            for (File file : files) {
                if (null != filename && file.getName().equalsIgnoreCase(filename)) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.searchFileInDir(file, filename));
            }
            return list;
        }
        return ListUtils.list(false);
    }

    public static void write(File file, CharSequence content, String encoding) throws IOException {
        FileUtils.write(file, content, encoding, false);
    }

    public static void write(File file, CharSequence content, String encoding, boolean append) throws IOException {
        FileUtils.write(file, content, Charsets.toCharset(encoding), append);
    }

    public static void write(File file, CharSequence content, Charset encoding) throws IOException {
        FileUtils.write(file, content, encoding, false);
    }

    public static void write(File file, CharSequence content, Charset encoding, boolean append) throws IOException {
        String str = content == null ? null : content.toString();
        FileUtils.writeString(file, str, encoding, append);
    }

    public static void writeString(File file, String content, String encoding) throws IOException {
        FileUtils.writeString(file, content, encoding, false);
    }

    public static void writeString(File file, String content, String encoding, boolean append) throws IOException {
        FileUtils.writeString(file, content, Charsets.toCharset(encoding), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String content, Charset encoding, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            IOUtils.write(content, (OutputStream)out, encoding);
            ((OutputStream)out).close();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void writeByteArray(File file, byte[] content) throws IOException {
        FileUtils.writeByteArray(file, content, false);
    }

    public static void writeByteArray(File file, byte[] content, boolean append) throws IOException {
        FileUtils.writeByteArray(file, content, 0, content.length, append);
    }

    public static void writeByteArray(File file, byte[] content, int off, int len) throws IOException {
        FileUtils.writeByteArray(file, content, off, len, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArray(File file, byte[] content, int off, int len, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            ((OutputStream)out).write(content, off, len);
            ((OutputStream)out).close();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static boolean writeByStream(String filePath, InputStream is, boolean append) throws IOException {
        return FileUtils.writeByStream(FileUtils.getFile(filePath), is, append);
    }

    /*
     * Loose catch block
     */
    public static boolean writeByStream(File file, InputStream is, boolean append) throws IOException {
        if (null == file || null == is) {
            return false;
        }
        if (!FileUtils.createOrExistsFile(file)) {
            return false;
        }
        try {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, append));){
                int len;
                byte[] data = new byte[1024];
                while ((len = is.read(data, 0, 1024)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                }
                boolean bl = true;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            is.close();
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        Validate.notNull(file, "file must be not null", new Object[0]);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static List<String> readFileList(String filePath, String charsetName) throws IOException {
        return FileUtils.readFileList(FileUtils.getFile(filePath), charsetName);
    }

    public static List<String> readFileList(File file, String charsetName) throws IOException {
        return FileUtils.readFileList(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFileList(String filePath, int st, int end, String charsetName) throws IOException {
        return FileUtils.readFileList(FileUtils.getFile(filePath), st, end, charsetName);
    }

    /*
     * Exception decompiling
     */
    public static List<String> readFileList(File file, int st, int end, String charsetName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readFileString(String filePath, String charsetName) throws IOException {
        return FileUtils.readFileString(FileUtils.getFile(filePath), charsetName);
    }

    public static String readFileString(File file, String charsetName) throws IOException {
        if (file == null) {
            return null;
        }
        if (StringUtils.isBlank(charsetName)) {
            charsetName = "UTF-8";
        }
        byte[] content = Files.readAllBytes(file.toPath());
        return new String(content, charsetName);
    }

    public static byte[] readFileBytes(String filePath) throws IOException {
        return FileUtils.readFileBytes(FileUtils.getFile(filePath));
    }

    public static byte[] readFileBytes(File file) throws IOException {
        if (null == file) {
            return null;
        }
        return Files.readAllBytes(file.toPath());
    }

    public static boolean copyOrMoveDir(String srcDirPath, String destDirPath, boolean isMove) throws IOException {
        return FileUtils.copyOrMoveDir(FileUtils.getFile(srcDirPath), FileUtils.getFile(destDirPath), isMove);
    }

    public static boolean copyOrMoveDir(File srcDir, File destDir, boolean isMove) throws IOException {
        if (null == srcDir || null == destDir) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        File[] files = srcDir.listFiles();
        if (null != files && files.length > 0) {
            for (File file : files) {
                File destFile = new File(destPath + file.getName());
                if (file.isFile() && !FileUtils.copyOrMoveFile(file, destFile, isMove)) {
                    return false;
                }
                if (!file.isDirectory() || FileUtils.copyOrMoveDir(file, destFile, isMove)) continue;
                return false;
            }
        }
        return !isMove || FileUtils.deleteDir(srcDir);
    }

    public static boolean copyOrMoveFile(String srcFilePath, String destFilePath, boolean isMove) throws IOException {
        return FileUtils.copyOrMoveFile(FileUtils.getFile(srcFilePath), FileUtils.getFile(destFilePath), isMove);
    }

    public static boolean copyOrMoveFile(File srcFile, File destFile, boolean isMove) throws IOException {
        if (null == srcFile || null == destFile) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (srcFile.exists() && destFile.isFile()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        return FileUtils.writeByStream(destFile, (InputStream)FileUtils.openInputStream(srcFile), false) && (!isMove || FileUtils.deleteFile(srcFile));
    }

    public static boolean copyDir(String srcDirPath, String destDirPath) throws IOException {
        return FileUtils.copyDir(FileUtils.getFile(srcDirPath), FileUtils.getFile(destDirPath));
    }

    public static boolean copyDir(File srcDir, File destDir) throws IOException {
        return FileUtils.copyOrMoveDir(srcDir, destDir, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath) throws IOException {
        return FileUtils.copyFile(FileUtils.getFile(srcFilePath), FileUtils.getFile(destFilePath));
    }

    public static boolean copyFile(File srcFile, File destFile) throws IOException {
        return FileUtils.copyOrMoveFile(srcFile, destFile, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath) throws IOException {
        return FileUtils.moveDir(FileUtils.getFile(srcDirPath), FileUtils.getFile(destDirPath));
    }

    public static boolean moveDir(File srcDir, File destDir) throws IOException {
        return FileUtils.copyOrMoveDir(srcDir, destDir, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath) throws IOException {
        return FileUtils.moveFile(FileUtils.getFile(srcFilePath), FileUtils.getFile(destFilePath));
    }

    public static boolean moveFile(File srcFile, File destFile) throws IOException {
        return FileUtils.copyOrMoveFile(srcFile, destFile, true);
    }

    public static int getFileLines(String filePath) throws IOException {
        return FileUtils.getFileLines(FileUtils.getFile(filePath));
    }

    public static int getFileLines(File file) throws IOException {
        int count = 1;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int readChars;
            byte[] buffer = new byte[1024];
            while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
        }
        return count;
    }
}

