/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.io;

import com.hb0730.commons.lang.Charsets;
import com.hb0730.commons.lang.Validate;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class IOUtils {
    public static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return IOUtils.copy(is, os, 1024);
    }

    public static long copy(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int len;
        Validate.notNull(is, "InputStream  is null", new Object[0]);
        Validate.notNull(os, "OutputStream  is null", new Object[0]);
        if (bufferSize <= 0) {
            bufferSize = 1024;
        }
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
            size += (long)len;
        }
        os.flush();
        return size;
    }

    public static String read(InputStream is) throws IOException {
        return IOUtils.read(is, com.hb0730.commons.lang.constants.Charsets.UTF_8);
    }

    public static String read(InputStream is, Charset charset) throws IOException {
        if (null == is) {
            return null;
        }
        if (null == charset || !Charset.isSupported(charset.name())) {
            charset = com.hb0730.commons.lang.constants.Charsets.UTF_8;
        }
        byte[] bytes = IOUtils.readBytes(is);
        return new String(bytes, charset);
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        if (null == is) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            IOUtils.copy(is, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (null != data && null != output) {
            output.write(data);
        }
    }

    public static void write(char[] data, OutputStream output, String encoding) throws IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(char[] data, OutputStream output, Charset encoding) throws IOException {
        if (null != data && null != output) {
            output.write(new String(data).getBytes(Charsets.toCharset(encoding)));
        }
    }

    public static void write(CharSequence data, OutputStream output, String encoding) throws IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(CharSequence data, OutputStream output, Charset encoding) throws IOException {
        if (null != data && null != output) {
            IOUtils.write(data.toString(), output, encoding);
        }
    }

    public static void write(String data, OutputStream out, Charset charset) throws IOException {
        if (null != data && null != out) {
            out.write(data.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void closeQuietly(OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable ... closes) {
        for (Closeable close : closes) {
            IOUtils.closeQuietly(close);
        }
    }
}

