/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.io;

import com.hb0730.commons.lang.ClassLoaderUtils;
import com.hb0730.commons.lang.collection.ListUtils;
import com.hb0730.commons.lang.io.IORuntimeException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public class ResourcesUtils {
    public static URL getResource(String resource) {
        return ResourcesUtils.getResource(resource, (Class)null);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ResourcesUtils.getResource(resource, (ClassLoader)null);
    }

    public static URL getResource(String location, ClassLoader loader) {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return null == loader ? ClassLoaderUtils.getClassLoader().getResource(path) : loader.getResource(path);
    }

    public static List<URL> getResources(String location) {
        return ResourcesUtils.getResources(location, null);
    }

    public static List<URL> getResources(String location, ClassLoader loader) {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> resources = null;
        try {
            resources = null == loader ? ClassLoaderUtils.getClassLoader().getResources(path) : loader.getResources(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return ListUtils.list(resources);
    }
}

