/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.map;

import com.hb0730.commons.lang.builder.Builder;
import com.hb0730.commons.lang.map.MapUtils;
import java.util.Map;

public class MapBuilder<K, V>
implements Builder<Map<K, V>> {
    private static final long serialVersionUID = -5240705513723579529L;
    private final Map<K, V> map;

    public static <K, V> MapBuilder<K, V> builder() {
        return MapBuilder.builder(MapUtils.newHashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(int initialCapacity) {
        return MapBuilder.builder(MapUtils.newHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public MapBuilder(Map<K, V> map) {
        this.map = map;
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    @Override
    public Map<K, V> build() {
        return this.map;
    }
}

