/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.map;

import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.net.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class MapUtils {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && !map.isEmpty();
    }

    public static <K, V> Map<K, V> defaultIfEmpty(Map<K, V> map) {
        return MapUtils.defaultIfEmpty(map, MapUtils.newHashMap());
    }

    public static <K, V> Map<K, V> defaultIfEmpty(Map<K, V> map, Map<K, V> defaultMap) {
        if (MapUtils.isEmpty(map)) {
            return defaultMap;
        }
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap(16);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        return isOrder ? new LinkedHashMap(size) : new HashMap(size);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtils.newHashMap(size, false);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtils.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static String parseMapToUrlString(Map<String, String> params, boolean encode) {
        if (CollectionUtils.isEmpty(params)) {
            return "";
        }
        ArrayList paramsList = new ArrayList();
        MapUtils.forEach(params, (k, v) -> {
            if (null == v) {
                paramsList.add(k + "=");
            } else {
                try {
                    paramsList.add(k + "=" + (encode ? UrlUtils.urlEncode(v) : v));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        return String.join((CharSequence)"&", paramsList);
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        if (CollectionUtils.isEmpty(map) || action == null) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapUtils.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result;
        if (null == map) {
            return null;
        }
        if (map instanceof TreeMap) {
            result = (TreeMap<K, V>)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        } else {
            result = MapUtils.newTreeMap(map, comparator);
        }
        return result;
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }
}

