/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.net;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.builder.Builder;
import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.exceptions.CommonsLangException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedList;

public class PathBuilder
implements Builder<String> {
    private final LinkedList<String> paths = new LinkedList();
    private boolean withEngTag;
    private Charset charset;

    public static PathBuilder builder(String path, Charset charset) {
        PathBuilder builder = null == charset ? new PathBuilder() : new PathBuilder(charset);
        builder.parse(path, charset);
        return builder;
    }

    public PathBuilder setWithEngTag(boolean withEngTag) {
        this.withEngTag = withEngTag;
        return this;
    }

    public PathBuilder addAfter(String path) {
        this.addInternal(this.fixPath(path), false);
        return this;
    }

    public PathBuilder addBefore(String path) {
        this.addInternal(this.fixPath(path), true);
        return this;
    }

    public PathBuilder parse(String path, Charset charset) {
        if (!StringUtils.isEmpty(path)) {
            if (path.endsWith("/")) {
                this.withEngTag = true;
            }
            String newPath = this.fixPath(path);
            String[] split = newPath.split("/");
            try {
                for (String seg : split) {
                    if (null == charset) {
                        this.addInternal(seg, false);
                        continue;
                    }
                    this.addInternal(URLDecoder.decode(seg, charset.name()), false);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CommonsLangException(e);
            }
        }
        return this;
    }

    public String build(Charset charset) {
        if (CollectionUtils.isEmpty(this.paths)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        try {
            for (String path : this.paths) {
                builder.append("/");
                if (null == charset) {
                    builder.append(path);
                    continue;
                }
                builder.append(URLEncoder.encode(path, charset.name()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CommonsLangException(e);
        }
        if (this.withEngTag || builder.length() == 0) {
            builder.append("/");
        }
        return builder.toString();
    }

    public PathBuilder(Charset charset) {
        this.charset = charset;
    }

    public PathBuilder() {
    }

    @Override
    public String build() {
        return this.build(this.charset);
    }

    private void addInternal(String path, boolean before) {
        if (before) {
            this.paths.add(0, path);
        } else {
            this.paths.add(path);
        }
    }

    private String fixPath(String path) {
        if (StringUtils.isBlank(path)) {
            return "";
        }
        String newPath = StringUtils.removePrefix(path, "/");
        newPath = StringUtils.removeSuffix(newPath, "/");
        return newPath.trim();
    }
}

