/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.net;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.builder.Builder;
import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.convert.ConverterRegistry;
import com.hb0730.commons.lang.exceptions.CommonsLangException;
import com.hb0730.commons.lang.map.MapUtils;
import com.hb0730.commons.lang.net.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryBuilder
implements Builder<String> {
    private final Map<CharSequence, CharSequence> querys;
    private final Charset charset;

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public static QueryBuilder builder(Charset charset) {
        return new QueryBuilder(charset);
    }

    public static QueryBuilder builder(Map<? extends CharSequence, ?> queryMap) {
        return new QueryBuilder(queryMap);
    }

    public static QueryBuilder builder(Map<? extends CharSequence, ?> queryMap, Charset charset) {
        return new QueryBuilder(queryMap, charset);
    }

    public static QueryBuilder builder(String queryStr, Charset charset) {
        QueryBuilder builder = new QueryBuilder(charset);
        builder.parse(queryStr);
        return builder;
    }

    public static QueryBuilder builder(String queryStr) {
        return QueryBuilder.builder(queryStr, null);
    }

    public QueryBuilder addAll(Map<? extends CharSequence, ?> queryMap) {
        if (CollectionUtils.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public QueryBuilder add(CharSequence key, Object value) {
        this.querys.put(key, ConverterRegistry.getInstance().convert((Type)((Object)String.class), value, null));
        return this;
    }

    public Map<CharSequence, CharSequence> getQuerys() {
        return MapUtils.unmodifiableMap(this.querys);
    }

    public CharSequence get(CharSequence key) {
        return this.querys.get(key);
    }

    public QueryBuilder(Map<? extends CharSequence, ?> queryMap, Charset charset) {
        this.charset = charset;
        if (CollectionUtils.isNotEmpty(queryMap)) {
            this.querys = new LinkedHashMap<CharSequence, CharSequence>(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.querys = new LinkedHashMap<CharSequence, CharSequence>(16);
        }
    }

    public QueryBuilder(Charset charset) {
        this(null, charset);
    }

    public QueryBuilder(Map<? extends CharSequence, ?> queryMap) {
        this(queryMap, null);
    }

    public QueryBuilder() {
        this(null, null);
    }

    public String build(Charset charset) {
        if (CollectionUtils.isEmpty(this.querys)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<CharSequence, CharSequence> entry : this.querys.entrySet()) {
            CharSequence key;
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append("&");
            }
            if (!StringUtils.isNotBlank(key = entry.getKey())) continue;
            builder.append(key);
            CharSequence value = entry.getValue();
            builder.append("=").append(value);
        }
        String query = builder.toString();
        try {
            if (null != charset) {
                query = UrlUtils.urlEncode(query, charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CommonsLangException(e);
        }
        return query;
    }

    @Override
    public String build() {
        return this.build(this.charset);
    }

    public QueryBuilder parse(String queryStr) {
        int i;
        if (StringUtils.isBlank(queryStr)) {
            return this;
        }
        int pathEndPos = queryStr.indexOf("?");
        String newStr = queryStr;
        if (pathEndPos > -1) {
            newStr = queryStr.substring(pathEndPos + 1);
        }
        String key = null;
        int pos = 0;
        int len = newStr.length();
        block4: for (i = 0; i < len; ++i) {
            char c = newStr.charAt(i);
            switch (c) {
                case '=': {
                    if (null != key) continue block4;
                    key = newStr.substring(pos, i);
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.addParams(key, newStr.substring(pos, i));
                    key = null;
                    if (i + 4 < len && "&amp;".equals(queryStr.substring(i + 1, i + 5))) {
                        i += 4;
                    }
                    pos = i + 1;
                    continue block4;
                }
            }
        }
        this.addParams(key, newStr.substring(pos, i));
        return this;
    }

    private void addParams(CharSequence key, CharSequence value) {
        try {
            if (null != key) {
                String decodeKey = UrlUtils.decode(key.toString(), this.charset);
                String decodeValue = UrlUtils.decode(value.toString(), this.charset);
                this.querys.put(decodeKey, decodeValue);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CommonsLangException(e);
        }
    }
}

