/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.reflect;

import com.hb0730.commons.lang.ClassUtils;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.Validate;
import com.hb0730.commons.lang.collection.ArrayUtils;
import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.exceptions.CommonsLangException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectUtils {
    public static final Pattern GET_PATTERN = Pattern.compile("get(\\p{javaUpperCase}\\w*)");
    public static final Pattern SET_PATTERN = Pattern.compile("set(\\p{javaUpperCase}\\w*)");

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtils.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtils.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectUtils.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Validate.notNull(beanClass, "class must be not null", new Object[0]);
        return ReflectUtils.getConstructorsDirectly(beanClass);
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        Validate.notNull(beanClass, "class must be not null", new Object[0]);
        return beanClass.getDeclaredConstructors();
    }

    public static <T> Object getFieldValue(T t, String targetField) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = t.getClass();
        while (true) {
            try {
                Field field = clazz.getDeclaredField(targetField);
                field.setAccessible(true);
                return field.get(t);
            }
            catch (Exception e) {
                if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
                    clazz = clazz.getSuperclass();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static <T> void setFieldValue(T t, String field, Object value) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = t.getClass();
        while (true) {
            try {
                Field target = clazz.getDeclaredField(field);
                target.setAccessible(true);
                target.set(t, value);
            }
            catch (Exception e) {
                if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
                    clazz = clazz.getSuperclass();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static <T> List<Field> getFields(Class<T> clazz, boolean containSupperClass) {
        if (null == clazz) {
            return null;
        }
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(fields));
        if (containSupperClass && clazz.getSuperclass() != null && !clazz.getSuperclass().getSimpleName().equals(Object.class.getSimpleName())) {
            list.addAll(ReflectUtils.getFields(clazz.getSuperclass(), containSupperClass));
        }
        return list;
    }

    public static <T> Field getField(Class<T> clazz, String fieldName, boolean containSupperClass) {
        if (null == clazz || StringUtils.isBlank(fieldName)) {
            return null;
        }
        List<Field> fields = ReflectUtils.getFields(clazz, containSupperClass);
        if (CollectionUtils.isEmpty(fields)) {
            return null;
        }
        for (Field field : fields) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static <T> List<Method> getMethods(Class<T> clazz, boolean containSupperClass) {
        if (null == clazz) {
            return null;
        }
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>(Arrays.asList(methods));
        if (containSupperClass && clazz.getSuperclass() != null && !clazz.getSuperclass().getSimpleName().equals(Object.class.getSimpleName())) {
            list.addAll(ReflectUtils.getMethods(clazz.getSuperclass(), containSupperClass));
        }
        return list;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramsType) {
        if (null == clazz || StringUtils.isBlank(methodName)) {
            return null;
        }
        List<Method> methods = ReflectUtils.getMethods(clazz, true);
        if (!CollectionUtils.isEmpty(methods)) {
            for (Method method : methods) {
                if (!StringUtils.equals(methodName, method.getName(), ignoreCase) || !ClassUtils.isAllAssignableFrom(method.getParameterTypes(), paramsType)) continue;
                return method;
            }
        }
        return null;
    }

    public static <T> List<Method> getGetterMethods(Class<T> clazz, boolean containSupperClass) {
        Method[] methods;
        if (null == clazz) {
            return null;
        }
        ArrayList<Method> getterMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Matcher m = GET_PATTERN.matcher(method.getName());
            if (!m.matches()) continue;
            getterMethods.add(method);
        }
        if (containSupperClass && clazz.getSuperclass() != null && !clazz.getSuperclass().getSimpleName().equals(Object.class.getSimpleName())) {
            getterMethods.addAll(ReflectUtils.getGetterMethods(clazz.getSuperclass(), containSupperClass));
        }
        return getterMethods;
    }

    public static <T> List<Method> getSetterMethods(Class<T> clazz, boolean containSupperClass) {
        Method[] methods;
        if (null == clazz) {
            return null;
        }
        ArrayList<Method> setterMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            Matcher matcher = SET_PATTERN.matcher(method.getName());
            if (!matcher.matches()) continue;
            setterMethods.add(method);
        }
        if (containSupperClass && clazz.getSuperclass() != null && !clazz.getSuperclass().getSimpleName().equals(Object.class.getSimpleName())) {
            setterMethods.addAll(ReflectUtils.getSetterMethods(clazz.getSuperclass(), containSupperClass));
        }
        return setterMethods;
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static <T> T newInstance(String clazz) throws CommonsLangException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new CommonsLangException("Instance class" + clazz + "error!", e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws CommonsLangException {
        if (ArrayUtils.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtils.getConstructor(clazz, new Class[0]);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CommonsLangException("Instance class" + clazz + "error!", e);
            }
        }
        Class<?>[] paramTypes = ReflectUtils.getMethodArgsType(params);
        Constructor<T> constructor = ReflectUtils.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new CommonsLangException("No Constructor matched for parameter types:" + Arrays.toString(new Object[]{paramTypes}));
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new CommonsLangException("Instance class" + clazz + "error!", e);
        }
    }

    public static <T> T invoke(Object bean, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?>[] type = ReflectUtils.getMethodArgsType(args);
        if (null == type) {
            Method method = bean.getClass().getMethod(methodName, new Class[0]);
            return ReflectUtils.invoke(bean, method, new Object[0]);
        }
        Method method = bean.getClass().getMethod(methodName, type);
        return ReflectUtils.invoke(bean, method, args);
    }

    public static <T> T invoke(Object bean, Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        if (null == bean || null == method) {
            return null;
        }
        return (T)method.invoke(bean, args);
    }

    public static Class<?>[] getMethodArgsType(Object ... args) {
        if (0 == args.length) {
            return null;
        }
        Class[] clazz = new Class[args.length];
        int index = 0;
        for (Object arg : args) {
            clazz[index] = arg.getClass();
            ++index;
        }
        return clazz;
    }
}

