/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.reflect;

import com.hb0730.commons.lang.collection.ArrayUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class TypeUtils {
    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeUtils.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = TypeUtils.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeUtils.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtils.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtils.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtils.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] interfaces;
            Class clazz = (Class)type;
            Type superclass = clazz.getGenericSuperclass();
            if ((null == superclass || Object.class.equals((Object)superclass)) && ArrayUtils.isNotEmpty(interfaces = clazz.getGenericInterfaces())) {
                superclass = interfaces[0];
            }
            result = TypeUtils.toParameterizedType(superclass);
        }
        return result;
    }

    public static boolean isUnknow(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static boolean hasTypeVeriable(Type ... types) {
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }
}

