/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.thread;

import com.hb0730.commons.lang.builder.Builder;
import com.hb0730.commons.lang.thread.RejectPolicy;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorBuilder
implements Builder<ThreadPoolExecutor> {
    private static final long serialVersionUID = -1542018033631957924L;
    private static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private int corePoolSize;
    private Integer maximumPoolSize;
    private long keepAliveTime = 0L;
    private TimeUnit timeUnit = TimeUnit.NANOSECONDS;
    private BlockingQueue<Runnable> workQueue;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private Boolean allowCoreThreadTimeOut;

    public ExecutorBuilder setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public ExecutorBuilder setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public ExecutorBuilder setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public ExecutorBuilder setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public ExecutorBuilder setWorkQueue(BlockingQueue<Runnable> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public ExecutorBuilder useSynchronousQueue() {
        return this.useSynchronousQueue(false);
    }

    public ExecutorBuilder useSynchronousQueue(boolean fair) {
        return this.setWorkQueue(new SynchronousQueue<Runnable>(fair));
    }

    public ExecutorBuilder useArrayBlockingQueue(int capacity) {
        return this.setWorkQueue(new ArrayBlockingQueue<Runnable>(capacity));
    }

    public ExecutorBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ExecutorBuilder setHandler(RejectedExecutionHandler handler) {
        this.handler = handler;
        return this;
    }

    public ExecutorBuilder setHandler(RejectPolicy handler) {
        return this.setHandler(handler.getValue());
    }

    public ExecutorBuilder setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public static ExecutorBuilder create() {
        return new ExecutorBuilder();
    }

    @Override
    public ThreadPoolExecutor build() {
        return ExecutorBuilder.build(this);
    }

    private static ThreadPoolExecutor build(ExecutorBuilder builder) {
        int corePoolSize = builder.corePoolSize;
        int maximumPoolSize = null != builder.maximumPoolSize ? builder.maximumPoolSize : (corePoolSize <= 0 ? 1 : corePoolSize << 1);
        long keepAliveTime = builder.keepAliveTime;
        TimeUnit timeUnit = builder.timeUnit;
        Queue<Runnable> workQueue = null != builder.workQueue ? builder.workQueue : (corePoolSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(1024));
        ThreadFactory threadFactory = null != builder.threadFactory ? builder.threadFactory : Executors.defaultThreadFactory();
        RejectedExecutionHandler handler = null != builder.handler ? builder.handler : new ThreadPoolExecutor.AbortPolicy();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, (BlockingQueue<Runnable>)workQueue, threadFactory, handler);
        if (null != builder.allowCoreThreadTimeOut) {
            threadPoolExecutor.allowCoreThreadTimeOut(builder.allowCoreThreadTimeOut);
        }
        return threadPoolExecutor;
    }
}

