/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.thread;

import com.hb0730.commons.lang.StringUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final boolean isDaemon;
    private final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String prefix, boolean isDaemon) {
        this(prefix, null, isDaemon);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon) {
        this(prefix, threadGroup, isDaemon, null);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon, Thread.UncaughtExceptionHandler handler) {
        this.prefix = StringUtils.isBlank(prefix) ? "thread-pool" : prefix;
        this.group = null != threadGroup ? threadGroup : Thread.currentThread().getThreadGroup();
        this.isDaemon = isDaemon;
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.group, r, String.format("%s%s", this.prefix, this.threadNumber.getAndIncrement()));
        if (!thread.isDaemon()) {
            if (this.isDaemon) {
                thread.setDaemon(true);
            }
        } else if (!this.isDaemon) {
            thread.setDaemon(false);
        }
        if (null != this.handler) {
            thread.setUncaughtExceptionHandler(this.handler);
        }
        if (5 != thread.getPriority()) {
            thread.setPriority(5);
        }
        return thread;
    }
}

