/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.lang.thread;

import com.hb0730.commons.lang.builder.Builder;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryBuilder
implements Builder<ThreadFactory> {
    private String namePrefix;
    private Boolean isDaemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler handler;
    private ThreadFactory threadFactory;

    public ThreadFactoryBuilder setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public ThreadFactoryBuilder isDaemon(boolean daemon) {
        this.isDaemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        if (priority > 10 || priority < 1) {
            throw new IllegalArgumentException(String.format(" If the priority is not in the range %s to %s", 1, 10));
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.handler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.threadFactory = backingThreadFactory;
        return this;
    }

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    @Override
    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        String namePrefix = builder.namePrefix;
        ThreadFactory threadFactory = null != builder.threadFactory ? builder.threadFactory : Executors.defaultThreadFactory();
        AtomicInteger poolNumber = null == namePrefix ? null : new AtomicInteger(1);
        Boolean isDaemon = builder.isDaemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler handler = builder.handler;
        return r -> {
            Thread thread = threadFactory.newThread(r);
            if (null != namePrefix) {
                thread.setName(namePrefix + poolNumber.getAndIncrement());
            }
            if (null != isDaemon) {
                thread.setDaemon(isDaemon);
            }
            if (null != priority) {
                thread.setPriority(priority);
            }
            if (null != handler) {
                thread.setUncaughtExceptionHandler(handler);
            }
            return thread;
        };
    }
}

