/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.spring.properties;

import com.hb0730.commons.lang.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class SpringMailProperties {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String protocol = "smtp";
    private Charset defaultEncoding = DEFAULT_CHARSET;
    private Map<String, String> properties = new HashMap<String, String>();
    private String jndiName;

    public SpringMailProperties(boolean needDebug) {
        this.addProperties("mail.debug", String.valueOf(needDebug));
        this.addProperties("mail.smtp.auth", Boolean.TRUE.toString());
        this.addProperties("mail.smtp.ssl.enable", Boolean.TRUE.toString());
        this.addProperties("mail.smtp.timeout", "10000");
    }

    public void addProperties(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toString() {
        String lineSuffix = ",\n";
        StringBuffer sb = new StringBuffer();
        sb.append("MailProperties{").append(",\n");
        sb.append("host=").append(this.getHost()).append(",\n");
        sb.append("username=").append(this.getUsername()).append(",\n");
        sb.append("password=").append(StringUtils.isBlank((CharSequence)this.getPassword()) ? "<null>" : "<non-null>");
        sb.append("port=").append(this.getPort()).append(",\n");
        sb.append("protocol=").append(this.getProtocol()).append(",\n");
        sb.append("defaultEncoding=").append(this.getDefaultEncoding()).append(",\n");
        sb.append("properties=").append(this.properties).append(",\n");
        sb.append('}');
        return sb.toString();
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setDefaultEncoding(Charset defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringMailProperties)) {
            return false;
        }
        SpringMailProperties other = (SpringMailProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Charset this$defaultEncoding = this.getDefaultEncoding();
        Charset other$defaultEncoding = other.getDefaultEncoding();
        if (this$defaultEncoding == null ? other$defaultEncoding != null : !((Object)this$defaultEncoding).equals(other$defaultEncoding)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$jndiName = this.getJndiName();
        String other$jndiName = other.getJndiName();
        return !(this$jndiName == null ? other$jndiName != null : !this$jndiName.equals(other$jndiName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringMailProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Charset $defaultEncoding = this.getDefaultEncoding();
        result = result * 59 + ($defaultEncoding == null ? 43 : ((Object)$defaultEncoding).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $jndiName = this.getJndiName();
        result = result * 59 + ($jndiName == null ? 43 : $jndiName.hashCode());
        return result;
    }
}

