/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.spring.service.impl;

import com.hb0730.commons.mail.spring.properties.MailProperties;
import com.hb0730.commons.mail.spring.service.AbstractMailService;
import freemarker.template.Template;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class MailServiceImpl
extends AbstractMailService {
    private final FreeMarkerConfigurer freeMarker;

    public MailServiceImpl(MailProperties properties, FreeMarkerConfigurer freeMarker) {
        super(properties);
        this.freeMarker = freeMarker;
    }

    @Override
    public void sendTextMail(String to, String subject, String content) {
        this.sendMailTemplate(true, messageHelper -> {
            messageHelper.setSubject(subject);
            messageHelper.setTo(to);
            messageHelper.setText(content);
        });
    }

    @Override
    public void sendTemplateMail(String to, String subject, Map<String, Object> content, String templateName) {
        this.sendMailTemplate(true, messageHelper -> {
            Template template = this.freeMarker.getConfiguration().getTemplate(templateName);
            String contentResult = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)content);
            messageHelper.setSubject(subject);
            messageHelper.setTo(to);
            messageHelper.setText(contentResult, true);
        });
    }

    @Override
    public void sendAttachMail(String to, String subject, Map<String, Object> content, String templateName, String attachFilePath) {
        this.sendMailTemplate(true, messageHelper -> {
            Template template = this.freeMarker.getConfiguration().getTemplate(templateName);
            String contentResult = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)content);
            messageHelper.setSubject(subject);
            messageHelper.setTo(to);
            Path attachmentPath = Paths.get(attachFilePath, new String[0]);
            messageHelper.addAttachment(attachmentPath.getFileName().toString(), attachmentPath.toFile());
            messageHelper.setText(contentResult, true);
        });
    }
}

