/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.java;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;
import com.hb0730.commons.mail.exceptions.MailException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

public class InternalMailUtil {
    public static InternetAddress[] parseAddressFromStrs(String[] addrStrs, Charset charset) {
        ArrayList resultList = new ArrayList(addrStrs.length);
        for (String addrStr : addrStrs) {
            Object[] addrs = InternalMailUtil.parseAddress(addrStr, charset);
            if (!ArrayUtils.isNotEmpty((Object[])addrs)) continue;
            Collections.addAll(resultList, addrs);
        }
        return resultList.toArray(new InternetAddress[0]);
    }

    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        InternetAddress[] addresses = InternalMailUtil.parseAddress(address, charset);
        if (StringUtils.isEmpty((CharSequence)address)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new MailException(e);
            }
        }
        return addresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        Object[] parsed = null;
        try {
            parsed = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException(e);
        }
        if (ArrayUtils.isNotEmpty((Object[])parsed)) {
            for (Object internetAddress : parsed) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new MailException(e);
                }
            }
        }
        return parsed;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

