/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.java;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.Validate;
import com.hb0730.commons.lang.collection.ArrayUtils;
import com.hb0730.commons.mail.exceptions.MailException;
import com.hb0730.commons.mail.java.GlobalMailAccount;
import com.hb0730.commons.mail.java.InternalMailUtil;
import com.hb0730.commons.mail.java.MailAccount;
import com.hb0730.commons.mail.java.UserPassAuthenticator;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mail {
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_CHARSET_SUFFIX = ";charset=";
    private final MailAccount account;
    private boolean useGlobalSession = false;
    private String subject;
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String[] reply;
    private String content;
    private boolean isHtml;
    private final Multipart multipart = new MimeMultipart();

    public static Mail create() {
        return new Mail();
    }

    public static Mail create(MailAccount account) {
        return new Mail(account);
    }

    public Mail() {
        this(GlobalMailAccount.INSTANCE.getAccount());
    }

    public Mail(MailAccount account) {
        this.account = account;
    }

    public boolean isUseGlobalSession() {
        return this.useGlobalSession;
    }

    public Mail useGlobalSession(boolean useGlobalSession) {
        this.useGlobalSession = useGlobalSession;
        return this;
    }

    public Mail tos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail ccs(String ... ccs) {
        this.ccs = ccs;
        return this;
    }

    public Mail bccs(String ... bccs) {
        this.bccs = bccs;
        return this;
    }

    public Mail replyTos(String ... reply) {
        this.reply = reply;
        return this;
    }

    public Mail subject(String subject) {
        this.subject = subject;
        return this;
    }

    public Mail charset(Charset charset) {
        this.account.charset(charset);
        return this;
    }

    public Mail content(String content) {
        this.content = content;
        return this;
    }

    public Mail html(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail content(String content, boolean isHtml) {
        this.content(content);
        return this.html(isHtml);
    }

    public Mail addAttachments(File ... files) {
        if (ArrayUtils.isEmpty((Object[])files)) {
            return this;
        }
        DataSource[] attachments = new DataSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            attachments[i] = new FileDataSource(files[i]);
        }
        return this.addAttachments(attachments);
    }

    public Mail addAttachments(DataSource ... attachments) {
        if (ArrayUtils.isNotEmpty((Object[])attachments)) {
            for (DataSource attachment : attachments) {
                this.addAttachment(attachment.getName(), attachment);
            }
        }
        return this;
    }

    public Mail addAttachment(String attachmentFilename, DataSource dataSource) {
        Validate.notNull((Object)attachmentFilename, (String)"Attachment filename must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)dataSource, (String)"DataSource must not be null", (Object[])new Object[0]);
        try {
            MimeBodyPart bodyPart = new MimeBodyPart();
            String nameEncoded = InternalMailUtil.encodeText(attachmentFilename, this.account.getCharset());
            bodyPart.setDisposition("attachment");
            bodyPart.setFileName(nameEncoded);
            bodyPart.setDataHandler(new DataHandler(dataSource));
            if (dataSource.getContentType().startsWith("image/")) {
                bodyPart.setContentID(nameEncoded);
            }
            this.multipart.addBodyPart((BodyPart)bodyPart);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to encode attachment filename", ex);
        }
        return this;
    }

    public Mail addAttachment(String attachmentFilename, File file) {
        Validate.notNull((Object)file, (String)"File must not be null", (Object[])new Object[0]);
        FileDataSource dataSource = new FileDataSource(file);
        return this.addAttachment(attachmentFilename, (DataSource)dataSource);
    }

    public Mail addAttachment(String attachmentFilename, URL url) {
        Validate.notNull((Object)url, (String)"url must not be null", (Object[])new Object[0]);
        DataHandler handler = new DataHandler(url);
        return this.addAttachment(attachmentFilename, handler.getDataSource());
    }

    public String send() {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            if (e instanceof SendFailedException) {
                Address[] invalidAddresses = ((SendFailedException)e).getInvalidAddresses();
                String msg = String.format("Invalid Addresses: %s", ArrayUtils.toString((Object)invalidAddresses));
                throw new MailException(msg, e);
            }
            throw new MailException(e);
        }
    }

    private String doSend() throws MessagingException {
        MimeMessage mimeMessage = this.buildMsg();
        Transport.send((Message)mimeMessage);
        return mimeMessage.getMessageID();
    }

    private MimeMessage buildMsg() throws MessagingException {
        Charset charset = this.account.getCharset();
        Session session = this.getSession();
        MimeMessage message = new MimeMessage(session);
        String from = this.account.getFrom();
        if (StringUtils.isBlank((CharSequence)from)) {
            message.setFrom();
        } else {
            message.setFrom((Address)this.getFromAddress());
        }
        message.setSubject(this.subject, charset.name());
        message.setSentDate(new Date());
        message.setContent(this.buildContent(charset));
        message.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMailUtil.parseAddressFromStrs(this.tos, charset));
        if (ArrayUtils.isNotEmpty((Object[])this.ccs)) {
            message.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMailUtil.parseAddressFromStrs(this.ccs, charset));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.bccs)) {
            message.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMailUtil.parseAddressFromStrs(this.bccs, charset));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.reply)) {
            message.setReplyTo((Address[])InternalMailUtil.parseAddressFromStrs(this.reply, charset));
        }
        return message;
    }

    private Multipart buildContent(Charset charset) throws MessagingException {
        MimeBodyPart body = new MimeBodyPart();
        if (this.isHtml) {
            this.setHtmlTextToMimePart(body, charset);
        } else {
            this.setPlainTextToMimePart(body, charset);
        }
        this.multipart.addBodyPart((BodyPart)body);
        return this.multipart;
    }

    private void setPlainTextToMimePart(MimeBodyPart body, Charset charset) throws MessagingException {
        if (null != charset) {
            body.setText(this.content, this.content);
        } else {
            body.setText(this.content);
        }
    }

    private void setHtmlTextToMimePart(MimeBodyPart body, Charset charset) throws MessagingException {
        if (null != charset) {
            body.setContent((Object)this.content, "text/html;charset=" + charset);
        } else {
            body.setContent((Object)this.content, CONTENT_TYPE_HTML);
        }
    }

    private InternetAddress getFromAddress() {
        try {
            return new InternetAddress(this.account.getUser(), this.account.getFrom(), this.account.getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MailException(e);
        }
    }

    private Session getSession() {
        UserPassAuthenticator authenticator = null;
        if (this.account.isAuth()) {
            authenticator = new UserPassAuthenticator(this.account.getUser(), this.account.getPassword());
        }
        return this.useGlobalSession ? Session.getDefaultInstance((Properties)this.account.getSmtpProps(), authenticator) : Session.getInstance((Properties)this.account.getSmtpProps(), authenticator);
    }
}

