/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.java;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.constants.Charsets;
import com.hb0730.commons.mail.java.Account;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

public class MailAccount
implements Account {
    private static final String MAIL_PROTOCOL = "mail.transport.protocol";
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String SMTP_TIMEOUT = "mail.smtp.timeout";
    private static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String SMTP_SSL_ENABLE = "mail.smtp.ssl.enable";
    private static final String SMTP_SSL_PROTOCOLS = "mail.smtp.ssl.protocols";
    private static final String SMTP_SOCKET_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    private static final String MAIL_DEBUG = "mail.debug";
    private String host;
    private Integer port;
    private boolean auth = true;
    private String user;
    private String password;
    private String from;
    private long timeout;
    private long connectionTimeout;
    private boolean sslEnable = true;
    private String sslProtocols;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback = true;
    private Integer socketFactoryPort = 465;
    private boolean debug;
    private Charset charset = Charsets.UTF_8;
    private Properties javaMailProperties;

    public String getHost() {
        return this.host;
    }

    @Override
    public MailAccount host(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    @Override
    public MailAccount port(Integer port) {
        this.port = port;
        return this;
    }

    public boolean isAuth() {
        return this.auth;
    }

    @Override
    public MailAccount auth(boolean auth) {
        this.auth = auth;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public MailAccount user(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public MailAccount password(String password) {
        this.password = password;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    @Override
    public MailAccount from(String from) {
        this.from = from;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public MailAccount timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public MailAccount connectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public boolean isSslEnabled() {
        return this.sslEnable;
    }

    @Override
    public MailAccount sslEnable(boolean sslEnable) {
        this.sslEnable = sslEnable;
        return this;
    }

    public String getSslProtocols() {
        return this.sslProtocols;
    }

    @Override
    public MailAccount sslProtocols(String sslProtocols) {
        this.sslProtocols = sslProtocols;
        return this;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    @Override
    public MailAccount socketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
        return this;
    }

    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    @Override
    public MailAccount socketFactoryFallback(boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
        return this;
    }

    public Integer getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    @Override
    public MailAccount socketFactoryPort(Integer socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public MailAccount debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public MailAccount charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public MailAccount javaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
        return this;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public Properties getSmtpProps() {
        Properties props = new Properties();
        props.put(MAIL_PROTOCOL, "smtp");
        props.put(SMTP_HOST, this.host);
        props.put(SMTP_PORT, String.valueOf(this.port));
        props.put(SMTP_AUTH, String.valueOf(this.auth));
        if (this.timeout > 0L) {
            props.put(SMTP_TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.connectionTimeout > 0L) {
            props.put(SMTP_CONNECTION_TIMEOUT, String.valueOf(this.connectionTimeout));
        }
        props.put(MAIL_DEBUG, String.valueOf(this.debug));
        if (this.sslEnable) {
            props.put(SMTP_SSL_ENABLE, "true");
            props.put(SMTP_SOCKET_FACTORY, this.socketFactoryClass);
            props.put(SMTP_SOCKET_FACTORY_FALLBACK, String.valueOf(this.socketFactoryFallback));
            props.put(SMTP_SOCKET_FACTORY_PORT, String.valueOf(this.socketFactoryPort));
            if (StringUtils.isNotBlank((CharSequence)this.sslProtocols)) {
                props.put(SMTP_SSL_PROTOCOLS, this.sslProtocols);
            }
        }
        if (null != this.getJavaMailProperties()) {
            props.putAll((Map<?, ?>)this.getJavaMailProperties());
        }
        return props;
    }

    public String toString() {
        return "MailAccount [host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", user=" + this.user + ", password=" + (StringUtils.isEmpty((CharSequence)this.password) ? "" : "******") + ", from=" + this.from + ", socketFactoryClass=" + this.socketFactoryClass + ", socketFactoryFallback=" + this.socketFactoryFallback + ", socketFactoryPort=" + this.socketFactoryPort + "]";
    }
}

