/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.spring.factory;

import com.hb0730.commons.mail.spring.properties.SpringMailProperties;
import java.util.Properties;
import org.springframework.lang.NonNull;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MailSenderFactory {
    public JavaMailSender getMailSender(@NonNull SpringMailProperties properties) {
        Assert.notNull((Object)properties, (String)"Mail properties must not be null");
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        this.setProperties(mailSender, properties);
        return mailSender;
    }

    private void setProperties(@NonNull JavaMailSenderImpl mailSender, @NonNull SpringMailProperties springMailProperties) {
        mailSender.setHost(springMailProperties.getHost());
        mailSender.setPort(springMailProperties.getPort().intValue());
        mailSender.setUsername(springMailProperties.getUsername());
        mailSender.setPassword(springMailProperties.getPassword());
        mailSender.setProtocol(springMailProperties.getProtocol());
        mailSender.setDefaultEncoding(springMailProperties.getDefaultEncoding().name());
        if (!CollectionUtils.isEmpty(springMailProperties.getProperties())) {
            Properties properties = new Properties();
            properties.putAll(springMailProperties.getProperties());
            mailSender.setJavaMailProperties(properties);
        }
    }
}

