/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.mail.spring.service;

import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.mail.exceptions.MailException;
import com.hb0730.commons.mail.spring.factory.MailSenderFactory;
import com.hb0730.commons.mail.spring.properties.MailProperties;
import com.hb0730.commons.mail.spring.properties.SpringMailProperties;
import com.hb0730.commons.mail.spring.service.MailService;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public abstract class AbstractMailService
implements MailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailService.class);
    private static final int DEFAULT_POOL_SIZE = 5;
    private String cacheFromName;
    private JavaMailSender cachedMailSender;
    private SpringMailProperties cachedMailProperties;
    private final MailProperties properties;
    private volatile ExecutorService executorService;

    public AbstractMailService(MailProperties properties) {
        this.properties = properties;
    }

    public void setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorService getExecutorService() {
        if (null == this.executorService) {
            AbstractMailService abstractMailService = this;
            synchronized (abstractMailService) {
                if (null == this.executorService) {
                    this.executorService = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("commonsMail-Pool"));
                }
            }
        }
        return this.executorService;
    }

    public synchronized JavaMailSender getMailSender() {
        if (null == this.cachedMailSender) {
            MailSenderFactory factory = new MailSenderFactory();
            this.cachedMailSender = factory.getMailSender(this.getMailProperties());
        }
        return this.cachedMailSender;
    }

    protected void sendMailTemplate(@Nullable Callback callback) {
        if (null == callback) {
            LOGGER.info("Callback is null, skip to send email");
            return;
        }
        Boolean enabled = this.properties.getEnabled();
        if (!enabled.booleanValue()) {
            LOGGER.info("Email has been disabled by yourself, you can re-enable it through email settings on admin page.");
            return;
        }
        JavaMailSender javaMailSender = this.getMailSender();
        MimeMessageHelper messageHelper = new MimeMessageHelper(javaMailSender.createMimeMessage());
        try {
            messageHelper.setFrom(this.getFromAddress(javaMailSender));
            callback.handle(messageHelper);
            MimeMessage mimeMessage = messageHelper.getMimeMessage();
            javaMailSender.send(mimeMessage);
            LOGGER.info("Sent an email to [{}] successfully, subject: [{}], sent date: [{}]", new Object[]{Arrays.toString(mimeMessage.getAllRecipients()), mimeMessage.getSubject(), mimeMessage.getSentDate()});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MailException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 SMTP \u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u786e", e);
        }
    }

    protected void sendMailTemplate(boolean tryToAsync, @NonNull Callback callback) {
        ExecutorService executorService = this.getExecutorService();
        if (tryToAsync) {
            executorService.execute(() -> this.sendMailTemplate(callback));
        } else {
            this.sendMailTemplate(callback);
        }
    }

    @Override
    public void testConnection() {
        JavaMailSender javaMailSender = this.getMailSender();
        if (javaMailSender instanceof JavaMailSenderImpl) {
            JavaMailSenderImpl mailSender = (JavaMailSenderImpl)javaMailSender;
            try {
                mailSender.testConnection();
            }
            catch (MessagingException e) {
                throw new MailException("\u65e0\u6cd5\u8fde\u63a5\u5230\u90ae\u7bb1\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u90ae\u7bb1\u914d\u7f6e", e);
            }
        }
    }

    private synchronized SpringMailProperties getMailProperties() {
        if (null == this.cachedMailProperties) {
            SpringMailProperties mailProperties = new SpringMailProperties(LOGGER.isDebugEnabled());
            mailProperties.setHost(this.properties.getHost());
            mailProperties.setPort(this.properties.getSslPort());
            mailProperties.setUsername(this.properties.getUsername());
            mailProperties.setPassword(this.properties.getPassword());
            mailProperties.setProtocol(this.properties.getProtocol());
            this.cachedMailProperties = mailProperties;
        }
        return this.cachedMailProperties;
    }

    private synchronized InternetAddress getFromAddress(@NonNull JavaMailSender javaMailSender) throws UnsupportedEncodingException {
        Assert.notNull((Object)javaMailSender, (String)"Java mail sender must not be null");
        if (StringUtils.isBlank((CharSequence)this.cacheFromName)) {
            this.cacheFromName = this.properties.getFromName();
        }
        if (javaMailSender instanceof JavaMailSenderImpl) {
            JavaMailSenderImpl mailSender = (JavaMailSenderImpl)javaMailSender;
            String username = mailSender.getUsername();
            return new InternetAddress(username, this.cacheFromName, mailSender.getDefaultEncoding());
        }
        throw new UnsupportedEncodingException("Unsupported java mail sender: " + javaMailSender.getClass().getName());
    }

    @Override
    public void clearCache() {
        this.cachedMailProperties = null;
        this.cacheFromName = null;
        this.cachedMailSender = null;
        LOGGER.debug("Cleared all mail caches");
    }

    protected static interface Callback {
        public void handle(@NonNull MimeMessageHelper var1) throws Exception;
    }
}

